/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPattern {
    private static Pattern paramPattern_ = Pattern.compile("\\{[^\\}^\\{]*\\}");
    private String[] tokens_;
    private String[] paramNames_;
    private String pattern_;
    private Set<String> params_;
    private int totalTokensLength_ = 0;

    public URIPattern(String patternString) {
        for (String t : this.tokens_ = paramPattern_.split(patternString, -1)) {
            if (t.length() == 0) {
                throw new IllegalArgumentException("Invalid pattern:" + patternString);
            }
            this.totalTokensLength_ += t.length();
        }
        int numParams = this.tokens_.length - 1;
        this.paramNames_ = new String[numParams];
        Matcher matcher = paramPattern_.matcher(patternString);
        int i = 0;
        while (matcher.find()) {
            this.paramNames_[i] = patternString.substring(matcher.start() + 1, matcher.end() - 1);
            ++i;
        }
        if (numParams > 0) assert (this.paramNames_[numParams - 1] != null);
        this.pattern_ = patternString;
        this.params_ = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.paramNames_)));
    }

    public Set<String> getParamNames() {
        return this.params_;
    }

    public Map<String, String> parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.paramNames_.length == 0) {
            if (string.equals(this.pattern_)) {
                return ret;
            }
            throw new IllegalArgumentException("Pattern not matched: " + this.pattern_ + ", " + string);
        }
        if (!this.matches(string)) {
            throw new IllegalArgumentException("Pattern not matched: " + this.pattern_ + ", " + string);
        }
        int pos = this.tokens_[0].length();
        for (int i = 0; i < this.paramNames_.length; ++i) {
            int nextPos;
            int n = nextPos = this.tokens_[i + 1].length() > 0 ? string.indexOf(this.tokens_[i + 1], pos) : string.length();
            if (nextPos < 0) {
                throw new IllegalArgumentException("Pattern not matched: " + this.pattern_ + ", " + string);
            }
            if (i == this.paramNames_.length - 1 && this.tokens_[i + 1].equals("/")) {
                ret.put(this.paramNames_[i], string.substring(pos, string.length() - 1));
            } else {
                ret.put(this.paramNames_[i], string.substring(pos, nextPos));
            }
            pos = nextPos + this.tokens_[i + 1].length();
        }
        return ret;
    }

    public boolean matches(String string) {
        if (this.paramNames_.length == 0 && !this.pattern_.equals(string)) {
            return false;
        }
        if (string.indexOf(this.tokens_[0], 0) != 0) {
            return false;
        }
        int pos = this.tokens_[0].length();
        for (int i = 0; i < this.paramNames_.length; ++i) {
            int nextPos;
            int n = nextPos = this.tokens_[i + 1].length() > 0 ? string.indexOf(this.tokens_[i + 1], pos) : string.length();
            if (nextPos < 0) {
                return false;
            }
            pos = nextPos + this.tokens_[i + 1].length();
        }
        return string.lastIndexOf(this.tokens_[this.tokens_.length - 1], string.length()) >= 0;
    }

    public boolean matches(URIPattern another) {
        return this.matches(another.getString());
    }

    public String getString() {
        return this.pattern_;
    }

    public int getTotalTokensLength() {
        return this.totalTokensLength_;
    }
}

