/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class DynamicProxyConverter
implements Converter {
    private ClassLoader classLoader;
    private ClassMapper classMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy;

    public DynamicProxyConverter(ClassMapper classMapper) {
        this(classMapper, (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter == null ? (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter = DynamicProxyConverter.class$("com.thoughtworks.xstream.converters.extended.DynamicProxyConverter")) : class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter).getClassLoader());
    }

    public DynamicProxyConverter(ClassMapper classMapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classMapper = classMapper;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy = DynamicProxyConverter.class$("com.thoughtworks.xstream.alias.ClassMapper$DynamicProxy")) : class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy) || Proxy.isProxyClass(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        this.addInterfacesToXml(object, hierarchicalStreamWriter);
        hierarchicalStreamWriter.startNode("handler");
        hierarchicalStreamWriter.addAttribute("class", this.classMapper.lookupName(invocationHandler.getClass()));
        marshallingContext.convertAnother(invocationHandler);
        hierarchicalStreamWriter.endNode();
    }

    private void addInterfacesToXml(Object object, HierarchicalStreamWriter hierarchicalStreamWriter) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            hierarchicalStreamWriter.startNode("interface");
            hierarchicalStreamWriter.setValue(this.classMapper.lookupName(clazz));
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Class[] classArray;
        ArrayList<Class> arrayList = new ArrayList<Class>();
        InvocationHandler invocationHandler = null;
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            classArray = hierarchicalStreamReader.getNodeName();
            if (classArray.equals("interface")) {
                arrayList.add(this.classMapper.lookupType(hierarchicalStreamReader.getValue()));
            } else if (classArray.equals("handler")) {
                Class clazz = this.classMapper.lookupType(hierarchicalStreamReader.getAttribute("class"));
                invocationHandler = (InvocationHandler)unmarshallingContext.convertAnother(null, clazz);
            }
            hierarchicalStreamReader.moveUp();
        }
        if (invocationHandler == null) {
            throw new ConversionException("No InvocationHandler specified for dynamic proxy");
        }
        classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        return Proxy.newProxyInstance(this.classLoader, classArray, invocationHandler);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

