/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.serialize;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.exoplatform.services.xml.serialize.GetterMap;
import org.exoplatform.services.xml.serialize.NodeMap;
import org.exoplatform.services.xml.serialize.SetterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    public Method getSetterMethod(Class<?> clazz, Field field) throws Exception {
        NodeMap map = field.getAnnotation(NodeMap.class);
        Method method = null;
        if (map != null) {
            method = this.getSetterMethodByMap(clazz, map);
        }
        if (method != null) {
            return method;
        }
        String name = this.getSetterOrGetter('s', field.getName());
        method = this.getMethodByName(clazz, name);
        if (method != null) {
            return method;
        }
        if (map != null) {
            name = map.value();
        }
        method = this.getMethodByName(clazz, name);
        return method;
    }

    public Method getGetterMethod(Class<?> clazz, Field field) throws Exception {
        NodeMap map = field.getAnnotation(NodeMap.class);
        Method method = null;
        if (map != null) {
            method = this.getGetterMethodByMap(clazz, map);
        }
        if (method != null) {
            return method;
        }
        String name = this.getSetterOrGetter('g', field.getName());
        method = this.getMethodByName(clazz, name);
        if (method != null) {
            return method;
        }
        if (map != null) {
            name = map.value();
        }
        method = this.getMethodByName(clazz, name);
        return method;
    }

    private Method getSetterMethodByMap(Class<?> clazz, NodeMap map) {
        Method[] methods;
        for (Method ele : methods = clazz.getDeclaredMethods()) {
            SetterMap getterMap = ele.getAnnotation(SetterMap.class);
            if (getterMap == null || !getterMap.value().equals(map.value())) continue;
            return ele;
        }
        Method method = this.getGetterMethodByMap(clazz.getSuperclass(), map);
        if (method != null) {
            return method;
        }
        return null;
    }

    private Method getGetterMethodByMap(Class<?> clazz, NodeMap map) {
        Method[] methods;
        for (Method ele : methods = clazz.getDeclaredMethods()) {
            GetterMap getterMap = ele.getAnnotation(GetterMap.class);
            if (getterMap == null || !getterMap.value().equals(map.value())) continue;
            return ele;
        }
        Method method = this.getGetterMethodByMap(clazz.getSuperclass(), map);
        if (method != null) {
            return method;
        }
        return null;
    }

    private Method getMethodByName(Class<?> clazz, String name) {
        Method method = this.getPublicMethodByName(clazz, name);
        if (method != null) {
            return method;
        }
        method = this.getProtectedMethodByName(clazz, name);
        if (method != null) {
            return method;
        }
        return null;
    }

    private Method getPublicMethodByName(Class<?> clazz, String name) {
        Method[] methods;
        for (Method ele : methods = clazz.getMethods()) {
            if (!name.equals(ele.getName())) continue;
            return ele;
        }
        return null;
    }

    private Method getProtectedMethodByName(Class<?> clazz, String name) {
        Method[] methods;
        for (Method ele : methods = clazz.getDeclaredMethods()) {
            if (ele.isAccessible() || !name.equals(ele.getName())) continue;
            return ele;
        }
        Method method = this.getProtectedMethodByName(clazz.getSuperclass(), name);
        if (method != null) {
            return method;
        }
        return null;
    }

    private String getSetterOrGetter(char c, String name) {
        char[] chars = new char[name.length() + 3];
        chars[0] = c;
        chars[1] = 101;
        chars[2] = 116;
        chars[3] = Character.toUpperCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            chars[i + 3] = name.charAt(i);
        }
        return new String(chars);
    }

    public boolean isPrimitiveType(Class<?> type) {
        return type == Integer.class || type == Long.class || type == Boolean.class || type == Double.class || type == Float.class || type == Short.class || type == Byte.class || type == Short.class || type == Character.class || type == String.class || type == StringBuffer.class || type == StringBuilder.class;
    }
}

