/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainer;
import org.exoplatform.services.portletcontainer.config.CustomMode;
import org.exoplatform.services.portletcontainer.config.CustomWindowState;
import org.exoplatform.services.portletcontainer.config.Description;
import org.exoplatform.services.portletcontainer.config.Properties;
import org.exoplatform.services.portletcontainer.config.SupportedContent;
import org.exoplatform.services.portletcontainer.pci.CustomModeWithDescription;
import org.exoplatform.services.portletcontainer.pci.CustomWindowStateWithDescription;
import org.exoplatform.services.portletcontainer.pci.LocalisedDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerConf {
    private Map<String, String> properties;
    private String name;
    private String description;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private Collection<PortletMode> customModes;
    private Collection<WindowState> customStates;
    private Collection<CustomModeWithDescription> customModesWithDescriptions;
    private Collection<CustomWindowStateWithDescription> customStatesWithDescriptions;
    private Collection<String> supportedContents;
    private boolean isCacheEnable;
    private PortletContainer containerConfs;
    private boolean isBundleLookupDelegated;

    public PortletContainerConf(InitParams params, ConfigurationManager cmanager) {
        try {
            ObjectParameter param = params.getObjectParam("conf");
            this.containerConfs = (PortletContainer)param.getObject();
            this.init();
        }
        catch (Exception e) {
            Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
            log.error((Object)(" -- PortletContainerConf.<init>: " + e));
        }
    }

    private void init() {
        String c = this.containerConfs.getCache().getEnable();
        if ("true".equals(c)) {
            this.isCacheEnable = true;
        }
        if ("true".equals(c = this.containerConfs.getDelegatedBundle().getEnable())) {
            this.isBundleLookupDelegated = true;
        }
    }

    public final Map<String, String> getProperties() {
        if (this.properties == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            List<Properties> l = this.containerConfs.getProperties();
            for (Properties props : l) {
                map.put(props.getName(), props.getValue());
            }
            this.properties = map;
        }
        return this.properties;
    }

    public final void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public final String getName() {
        if (this.name == null) {
            this.name = this.containerConfs.getGlobal().getName();
        }
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        if (this.description == null) {
            this.description = this.containerConfs.getGlobal().getDescription();
        }
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final int getMajorVersion() {
        if (this.majorVersion < 0) {
            this.majorVersion = this.containerConfs.getGlobal().getMajorVersion();
        }
        return this.majorVersion;
    }

    public final void setMajorVersion(int version) {
        this.majorVersion = version;
    }

    public final int getMinorVersion() {
        if (this.minorVersion < 0) {
            this.minorVersion = this.containerConfs.getGlobal().getMinorVersion();
        }
        return this.minorVersion;
    }

    public final void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public final Collection<String> getSupportedContent() {
        if (this.supportedContents == null) {
            this.supportedContents = new ArrayList<String>();
            List<SupportedContent> content = this.containerConfs.getSupportedContent();
            for (SupportedContent element : content) {
                this.supportedContents.add(element.getName());
            }
        }
        return this.supportedContents;
    }

    public final Enumeration<PortletMode> getSupportedPortletModes() {
        if (this.customModes == null) {
            ArrayList<PortletMode> v = new ArrayList<PortletMode>();
            v.add(PortletMode.EDIT);
            v.add(PortletMode.HELP);
            v.add(PortletMode.VIEW);
            List<CustomMode> l = this.containerConfs.getCustomMode();
            for (CustomMode customMode : l) {
                v.add(new PortletMode(customMode.getName()));
            }
            this.customModes = v;
        }
        return Collections.enumeration(this.customModes);
    }

    public final Enumeration<WindowState> getSupportedWindowStates() {
        if (this.customStates == null) {
            ArrayList<WindowState> v = new ArrayList<WindowState>();
            v.add(WindowState.NORMAL);
            v.add(WindowState.MINIMIZED);
            v.add(WindowState.MAXIMIZED);
            List<CustomWindowState> l = this.containerConfs.getCustomWindowState();
            for (CustomWindowState customState : l) {
                v.add(new WindowState(customState.getName()));
            }
            this.customStates = v;
        }
        return Collections.enumeration(this.customStates);
    }

    public final Collection<CustomModeWithDescription> getSupportedPortletModesWithDescriptions() {
        if (this.customModesWithDescriptions == null) {
            ArrayList<CustomModeWithDescription> v = new ArrayList<CustomModeWithDescription>();
            List<CustomMode> l = this.containerConfs.getCustomMode();
            for (CustomMode customMode : l) {
                List<Description> l2 = customMode.getDescription();
                ArrayList<LocalisedDescription> toBeReturned = new ArrayList<LocalisedDescription>();
                for (Description element : l2) {
                    LocalisedDescription d = new LocalisedDescription(new Locale(element.getLang()), element.getDescription());
                    toBeReturned.add(d);
                }
                CustomModeWithDescription cMWD = new CustomModeWithDescription(new PortletMode(customMode.getName()), toBeReturned);
                v.add(cMWD);
            }
            this.customModesWithDescriptions = v;
        }
        return this.customModesWithDescriptions;
    }

    public final Collection<CustomWindowStateWithDescription> getSupportedWindowStatesWithDescriptions() {
        if (this.customStatesWithDescriptions == null) {
            ArrayList<CustomWindowStateWithDescription> v = new ArrayList<CustomWindowStateWithDescription>();
            List<CustomWindowState> l = this.containerConfs.getCustomWindowState();
            for (CustomWindowState customState : l) {
                List<Description> l2 = customState.getDescription();
                ArrayList<LocalisedDescription> toBeReturned = new ArrayList<LocalisedDescription>();
                for (Description element : l2) {
                    LocalisedDescription d = new LocalisedDescription(new Locale(element.getLang()), element.getDescription());
                    toBeReturned.add(d);
                }
                CustomWindowStateWithDescription cMWD = new CustomWindowStateWithDescription(new WindowState(customState.getName()), toBeReturned);
                v.add(cMWD);
            }
            this.customStatesWithDescriptions = v;
        }
        return this.customStatesWithDescriptions;
    }

    public final boolean isModeSupported(PortletMode mode) {
        Enumeration<PortletMode> e = this.getSupportedPortletModes();
        while (e.hasMoreElements()) {
            PortletMode portletMode = e.nextElement();
            if (!portletMode.toString().equals(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public final boolean isStateSupported(WindowState state) {
        Enumeration<WindowState> e = this.getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState windowState = e.nextElement();
            if (!windowState.toString().equals(state.toString())) continue;
            return true;
        }
        return false;
    }

    public final boolean isCacheEnable() {
        return this.isCacheEnable;
    }

    public final boolean isBundleLookupDelegated() {
        return this.isBundleLookupDelegated;
    }
}

