/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerPlugin;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerServiceImpl
implements PortletContainerService,
Startable {
    private final ArrayList<PortletContainerPlugin> plugins = new ArrayList();
    private final ExoContainer container;
    private final PortletContainerConf config;

    public PortletContainerServiceImpl(ExoContainerContext context) {
        this.container = context.getContainer();
        this.config = (PortletContainerConf)this.container.getComponentInstanceOfType(PortletContainerConf.class);
    }

    @Override
    public final void addPlugin(PortletContainerPlugin plugin) {
        System.out.println(" PortletContainerServiceImpl plugin registered: " + plugin);
        this.plugins.add(plugin);
    }

    public final void start() {
    }

    public final void stop() {
    }

    @Override
    public final void setName(String name) {
        this.config.setName(name);
    }

    @Override
    public final void setDescription(String description) {
        this.config.setDescription(description);
    }

    @Override
    public final void setMajorVersion(int version) {
        this.config.setMajorVersion(version);
    }

    @Override
    public final void setMinorVersion(int version) {
        this.config.setMinorVersion(version);
    }

    @Override
    public final void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    @Override
    public final Collection<PortletMode> getSupportedPortletModes() {
        ArrayList<PortletMode> result = new ArrayList<PortletMode>();
        for (Object plugin : this.plugins.toArray()) {
            Collection<PortletMode> forAdd = ((PortletContainerPlugin)plugin).getSupportedPortletModes();
            if (forAdd == null) continue;
            result.addAll(forAdd);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public final Collection<WindowState> getSupportedWindowStates() {
        ArrayList<WindowState> result = new ArrayList<WindowState>();
        for (Object plugin : this.plugins.toArray()) {
            Collection<WindowState> forAdd = ((PortletContainerPlugin)plugin).getSupportedWindowStates();
            if (forAdd == null) continue;
            result.addAll(forAdd);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public final Collection<PortletMode> getPortletModes(String portletAppName, String portletName, String markup) {
        try {
            return this.findPluginByPAPPName(portletAppName).getPortletModes(portletAppName, portletName, markup);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        return this.findPluginByPAPPName(portletAppName).isModeSuported(portletAppName, portletName, markup, mode);
    }

    @Override
    public final Collection<WindowState> getWindowStates(String portletAppName, String portletName, String markup) {
        try {
            return this.findPluginByPAPPName(portletAppName).getWindowStates(portletAppName, portletName, markup);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final boolean isStateSupported(String portletAppName, String portletName, String markup, WindowState state) {
        return this.findPluginByPAPPName(portletAppName).isStateSupported(portletAppName, portletName, markup, state);
    }

    @Override
    public final Map<String, PortletData> getAllPortletMetaData() {
        HashMap<String, PortletData> result = new HashMap<String, PortletData>();
        for (Object plugin : this.plugins.toArray()) {
            result.putAll(((PortletContainerPlugin)plugin).getAllPortletMetaData());
        }
        return result;
    }

    @Override
    public final PortletApp getPortletApp(String portletAppName) {
        return this.findPluginByPAPPName(portletAppName).getPortletApp(portletAppName);
    }

    @Override
    public final ResourceBundle getBundle(HttpServletRequest request, HttpServletResponse response, String portletAppName, String portletName, Locale locale) throws PortletContainerException {
        return this.findPluginByPAPPName(portletAppName).getBundle(request, response, portletAppName, portletName, locale);
    }

    protected final PortletContainerPlugin findPluginByPAPPName(String papp) {
        for (Object plugin : this.plugins.toArray()) {
            Map<String, PortletData> plts = ((PortletContainerPlugin)plugin).getAllPortletMetaData();
            Set<String> keys = plts.keySet();
            for (String s : keys) {
                if (!s.startsWith(papp + "/")) continue;
                return (PortletContainerPlugin)plugin;
            }
        }
        return null;
    }

    @Override
    public final void setPortletPreference(Input input, Map<String, String> preferences) throws PortletContainerException {
        PortletContainerPlugin plugin = this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName());
        plugin.setPortletPreference(input, preferences);
    }

    @Override
    public final Map<String, String[]> getPortletPreference(Input input) {
        PortletContainerPlugin plugin = this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName());
        return plugin.getPortletPreference(input);
    }

    @Override
    public final ActionOutput processAction(HttpServletRequest request, HttpServletResponse response, ActionInput input) throws PortletContainerException {
        return this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName()).processAction(request, response, input);
    }

    @Override
    public final EventOutput processEvent(HttpServletRequest request, HttpServletResponse response, EventInput input) throws PortletContainerException {
        return this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName()).processEvent(request, response, input);
    }

    @Override
    public final ResourceOutput serveResource(HttpServletRequest request, HttpServletResponse response, ResourceInput input) throws PortletContainerException {
        return this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName()).serveResource(request, response, input);
    }

    @Override
    public final RenderOutput render(HttpServletRequest request, HttpServletResponse response, RenderInput input) throws PortletContainerException {
        return this.findPluginByPAPPName(input.getInternalWindowID().getPortletApplicationName()).render(request, response, input);
    }

    @Override
    public final void sendAttrs(HttpServletRequest request, HttpServletResponse response, Map<String, Object> attrs, String portletApplicationName) throws PortletContainerException {
        this.findPluginByPAPPName(portletApplicationName).sendAttrs(request, response, attrs, portletApplicationName);
    }

    @Override
    public final boolean isEventPayloadTypeMatches(String portletAppName, QName eventName, Object payload) throws PortletContainerException {
        return this.findPluginByPAPPName(portletAppName).isEventPayloadTypeMatches(portletAppName, eventName, payload);
    }
}

