/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.monitor;

public class PortletRequestMonitorData {
    private static final int REQUESTS_TO_SKIP = -5;
    private final long minRange;
    private final long maxRange;
    private int actionRequestCounter;
    private long minActionExecutionTime;
    private long maxActionExecutionTime;
    private long sumActionExecutionTime = 0L;
    private int renderRequestCounter;
    private long minRenderExecutionTime;
    private long maxRenderExecutionTime;
    private long sumRenderExecutionTime = 0L;
    private int eventRequestCounter;
    private long minEventExecutionTime;
    private long maxEventExecutionTime;
    private long sumEventExecutionTime = 0L;
    private int resourceRequestCounter;
    private long minResourceExecutionTime;
    private long maxResourceExecutionTime;
    private long sumResourceExecutionTime = 0L;
    private int cacheHitCounter;

    public PortletRequestMonitorData(long minRange, long maxRange) {
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.actionRequestCounter = -5;
        this.minActionExecutionTime = 0L;
        this.maxActionExecutionTime = 0L;
        this.renderRequestCounter = -5;
        this.minRenderExecutionTime = 0L;
        this.maxRenderExecutionTime = 0L;
        this.eventRequestCounter = -5;
        this.minEventExecutionTime = 0L;
        this.maxEventExecutionTime = 0L;
        this.resourceRequestCounter = -5;
        this.minResourceExecutionTime = 0L;
        this.maxResourceExecutionTime = 0L;
        this.cacheHitCounter = 0;
    }

    public final long minRange() {
        return this.minRange;
    }

    public final long maxRange() {
        return this.maxRange;
    }

    public final int getActionRequestCounter() {
        return this.actionRequestCounter;
    }

    public final int getRenderRequestCounter() {
        return this.renderRequestCounter;
    }

    public final int getEventRequestCounter() {
        return this.eventRequestCounter;
    }

    public final int getResourceRequestCounter() {
        return this.resourceRequestCounter;
    }

    public final int getCacheHitCounter() {
        return this.cacheHitCounter;
    }

    public final long getMinActionExecutionTime() {
        return this.minActionExecutionTime;
    }

    public final long getMinRenderExecutionTime() {
        return this.minRenderExecutionTime;
    }

    public final long getMinEventExecutionTime() {
        return this.minEventExecutionTime;
    }

    public final long getMinResourceExecutionTime() {
        return this.minResourceExecutionTime;
    }

    public final long getMaxActionExecutionTime() {
        return this.maxActionExecutionTime;
    }

    public final long getMaxRenderExecutionTime() {
        return this.maxRenderExecutionTime;
    }

    public final long getMaxEventExecutionTime() {
        return this.maxEventExecutionTime;
    }

    public final long getMaxResourceExecutionTime() {
        return this.maxResourceExecutionTime;
    }

    public final long getAvgActionExecutionTime() {
        if (this.actionRequestCounter <= 0) {
            return 0L;
        }
        return this.sumActionExecutionTime / (long)this.actionRequestCounter;
    }

    public final long getAvgRenderExecutionTime() {
        if (this.renderRequestCounter <= 0) {
            return 0L;
        }
        return this.sumRenderExecutionTime / (long)this.renderRequestCounter;
    }

    public final long getAvgEventExecutionTime() {
        if (this.eventRequestCounter <= 0) {
            return 0L;
        }
        return this.sumEventExecutionTime / (long)this.eventRequestCounter;
    }

    public final long getAvgResourceExecutionTime() {
        if (this.resourceRequestCounter <= 0) {
            return 0L;
        }
        return this.sumResourceExecutionTime / (long)this.resourceRequestCounter;
    }

    public final long sumActionExecutionTime() {
        return this.sumActionExecutionTime;
    }

    public final long sumRenderExecutionTime() {
        return this.sumRenderExecutionTime;
    }

    public final long sumEventExecutionTime() {
        return this.sumEventExecutionTime;
    }

    public final long sumResourceExecutionTime() {
        return this.sumResourceExecutionTime;
    }

    public final void logActionRequest(long executionTime) {
        ++this.actionRequestCounter;
        if (this.actionRequestCounter > 0) {
            this.sumActionExecutionTime += executionTime;
            if (executionTime < this.minActionExecutionTime) {
                this.minActionExecutionTime = executionTime;
            }
            if (executionTime > this.maxActionExecutionTime) {
                this.maxActionExecutionTime = executionTime;
            }
        } else {
            this.minActionExecutionTime = executionTime;
            this.maxActionExecutionTime = executionTime;
        }
    }

    public final void logRenderRequest(long executionTime, boolean cacheHit) {
        ++this.renderRequestCounter;
        if (this.renderRequestCounter > 0) {
            this.sumRenderExecutionTime += executionTime;
            if (cacheHit) {
                ++this.cacheHitCounter;
            }
            if (executionTime < this.minRenderExecutionTime) {
                this.minRenderExecutionTime = executionTime;
            }
            if (executionTime > this.maxRenderExecutionTime) {
                this.maxRenderExecutionTime = executionTime;
            }
        } else {
            this.minRenderExecutionTime = executionTime;
            this.maxRenderExecutionTime = executionTime;
        }
    }

    public final void logEventRequest(long executionTime) {
        ++this.eventRequestCounter;
        if (this.eventRequestCounter > 0) {
            this.sumEventExecutionTime += executionTime;
            if (executionTime < this.minEventExecutionTime) {
                this.minEventExecutionTime = executionTime;
            }
            if (executionTime > this.maxEventExecutionTime) {
                this.maxEventExecutionTime = executionTime;
            }
        } else {
            this.minEventExecutionTime = executionTime;
            this.maxEventExecutionTime = executionTime;
        }
    }

    public final void logResourceRequest(long executionTime, boolean cacheHit) {
        ++this.resourceRequestCounter;
        if (this.resourceRequestCounter > 0) {
            this.sumResourceExecutionTime += executionTime;
            if (cacheHit) {
                ++this.cacheHitCounter;
            }
            if (executionTime < this.minResourceExecutionTime) {
                this.minResourceExecutionTime = executionTime;
            }
            if (executionTime > this.maxResourceExecutionTime) {
                this.maxResourceExecutionTime = executionTime;
            }
        } else {
            this.minResourceExecutionTime = executionTime;
            this.maxResourceExecutionTime = executionTime;
        }
    }
}

