/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.PortletResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPortletApplication;

public class PortletApplication
extends WebuiApplication {
    protected static Log log = ExoLogger.getLogger((String)"portlet:PortletApplication");
    private PortletConfig portletConfig_;
    private String applicationId_;

    public PortletApplication(PortletConfig config) throws Exception {
        this.portletConfig_ = config;
        PortletContext pcontext = config.getPortletContext();
        String contextName = pcontext.getPortletContextName();
        this.applicationId_ = contextName + "/" + config.getPortletName();
        ApplicationResourceResolver resolver = new ApplicationResourceResolver();
        resolver.addResourceResolver((ResourceResolver)new PortletResourceResolver(pcontext, "app:"));
        resolver.addResourceResolver((ResourceResolver)new PortletResourceResolver(pcontext, "par:"));
        this.setResourceResolver(resolver);
    }

    public String getApplicationId() {
        return this.applicationId_;
    }

    public String getApplicationName() {
        return this.portletConfig_.getPortletName();
    }

    public String getApplicationGroup() {
        return this.portletConfig_.getPortletContext().getPortletContextName();
    }

    public String getApplicationType() {
        return "jsr168Application";
    }

    public ResourceBundle getResourceBundle(Locale locale) throws Exception {
        return this.portletConfig_.getResourceBundle(locale);
    }

    public ResourceBundle getOwnerResourceBundle(String username, Locale locale) throws Exception {
        return null;
    }

    public String getApplicationInitParam(String name) {
        return this.portletConfig_.getInitParameter(name);
    }

    public ExoContainer getApplicationServiceContainer() {
        return PortalContainer.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest req, ActionResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                lifecycle.onStartRequest((Application)this, (RequestContext)context);
            }
            UIApplication uiApp = this.getStateManager().restoreUIRootComponent(context);
            context.setUIApplication(uiApp);
            this.processDecode(uiApp, context);
            if (!context.isResponseComplete() && !context.getProcessRender()) {
                this.processAction(uiApp, context);
            }
        }
        finally {
            context.setProcessAction(true);
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest req, RenderResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            if (!context.hasProcessAction()) {
                for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                    lifecycle.onStartRequest((Application)this, (RequestContext)context);
                }
            }
            UIApplication uiApp = this.getStateManager().restoreUIRootComponent(context);
            context.setUIApplication(uiApp);
            if (!context.isResponseComplete()) {
                UIPortletApplication uiPortletApp = (UIPortletApplication)uiApp;
                uiPortletApp.processRender(this, context);
            }
            uiApp.setLastAccessApplication(System.currentTimeMillis());
        }
        finally {
            try {
                for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                    lifecycle.onEndRequest((Application)this, (RequestContext)context);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error while trying to call onEndRequest of the portlet ApplicationLifecycle", (Throwable)exception);
            }
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    private PortletRequestContext createRequestContext(PortletRequest req, PortletResponse res, WebuiRequestContext parentAppRequestContext) throws IOException {
        String attributeName = this.getApplicationId() + "$PortletRequest";
        PortletRequestContext context = (PortletRequestContext)((Object)parentAppRequestContext.getAttribute(attributeName));
        PrintWriter w = null;
        if (res instanceof RenderResponse) {
            RenderResponse renderRes = (RenderResponse)res;
            renderRes.setContentType("text/html; charset=UTF-8");
            w = renderRes.getWriter();
        }
        if (context != null) {
            context.init(w, req, res);
        } else {
            context = new PortletRequestContext(this, w, req, res);
            parentAppRequestContext.setAttribute(attributeName, (Object)context);
        }
        context.setParentAppRequestContext(parentAppRequestContext);
        return context;
    }
}

