/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIContainer;

public class WebuiBindingContext
extends BindingContext {
    private static boolean DEVELOPING = false;
    protected static Log log;
    private UIComponent uicomponent_;
    private WebuiRequestContext rcontext_;

    public WebuiBindingContext(ResourceResolver resolver, Writer w, UIComponent uicomponent, WebuiRequestContext context) {
        super(resolver, w);
        this.uicomponent_ = uicomponent;
        this.rcontext_ = context;
    }

    public UIComponent getUIComponent() {
        return this.uicomponent_;
    }

    public WebuiRequestContext getRequestContext() {
        return this.rcontext_;
    }

    public BindingContext clone() {
        WebuiBindingContext newContext = new WebuiBindingContext(this.resolver_, this.writer_, this.uicomponent_, this.rcontext_);
        newContext.putAll((Map)((Object)this));
        newContext.setGroovyTemplateService(this.service_);
        return newContext;
    }

    public String appRes(String mesgKey) throws Exception {
        String value;
        try {
            ResourceBundle res = this.rcontext_.getApplicationResourceBundle();
            value = res.getString(mesgKey);
        }
        catch (MissingResourceException ex) {
            if (DEVELOPING) {
                log.warn((Object)("Can not find resource bundle for key : " + mesgKey));
            }
            value = mesgKey.substring(mesgKey.lastIndexOf(46) + 1);
        }
        return value;
    }

    public void renderChildren() throws Exception {
        if (this.uicomponent_ instanceof UIComponentDecorator) {
            UIComponentDecorator uiComponentDecorator = (UIComponentDecorator)this.uicomponent_;
            if (uiComponentDecorator.getUIComponent() == null) {
                return;
            }
            uiComponentDecorator.getUIComponent().processRender(this.rcontext_);
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        List<UIComponent> children = uicontainer.getChildren();
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            child.processRender(this.rcontext_);
        }
    }

    public void renderChild(String id) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChildById(id);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }

    public void renderUIComponent(UIComponent uicomponent) throws Exception {
        uicomponent.processRender(this.rcontext_);
    }

    public void renderChild(int index) throws Exception {
        if (!(this.uicomponent_ instanceof UIContainer)) {
            return;
        }
        UIContainer uicontainer = (UIContainer)this.uicomponent_;
        Object uiChild = uicontainer.getChild(index);
        ((UIComponent)uiChild).processRender(this.rcontext_);
    }

    public void userRes(String mesgKey) {
    }

    static {
        DEVELOPING = "true".equals(System.getProperty("exo.product.developing"));
        log = ExoLogger.getLogger((String)"portal:WebuiBindingContext");
    }
}

