/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.observation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.jcr.impl.core.observation.ActionLauncher;
import org.exoplatform.services.jcr.impl.core.observation.ListenerCriteria;
import org.exoplatform.services.jcr.impl.core.observation.ObservationManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.log.ExoLogger;

public class ObservationManagerRegistry {
    protected static Log log = ExoLogger.getLogger((String)"jcr.RepositoryService");
    protected Map<EventListener, ListenerCriteria> listenersMap = new HashMap<EventListener, ListenerCriteria>();
    protected ActionLauncher launcher;

    public ObservationManagerRegistry(WorkspacePersistentDataManager workspaceDataManager, SessionRegistry sessionRegistry) {
        this.launcher = new ActionLauncher(this, workspaceDataManager, sessionRegistry);
    }

    public ObservationManagerImpl createObservationManager(SessionImpl session) {
        return new ObservationManagerImpl(this, session.getId());
    }

    public void addEventListener(EventListener listener, ListenerCriteria filter) {
        this.listenersMap.put(listener, filter);
    }

    public void removeEventListener(EventListener listener) {
        this.listenersMap.remove(listener);
    }

    public EventListenerIterator getEventListeners() {
        return new EntityCollection(this.listenersMap.keySet());
    }

    public ListenerCriteria getListenerFilter(EventListener listener) {
        return this.listenersMap.get(listener);
    }

    public void removeSessionEventListeners(SessionImpl session) {
        ArrayList<EventListener> eventsForRemove = new ArrayList<EventListener>();
        for (EventListener listener : this.listenersMap.keySet()) {
            ListenerCriteria criteria = this.listenersMap.get(listener);
            if (!criteria.getSessionId().equals(session.getId())) continue;
            eventsForRemove.add(listener);
        }
        for (EventListener listener : eventsForRemove) {
            this.listenersMap.remove(listener);
        }
    }
}

