/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Serializable;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;

class CacheQPath
implements Serializable {
    private final String parentId;
    private final QPath path;
    private final String key;

    CacheQPath(String parentId, QPath path) {
        this.parentId = parentId;
        this.path = path;
        this.key = this.key(this.parentId, this.path.getEntries());
    }

    CacheQPath(String parentId, QPathEntry name) {
        this.parentId = parentId;
        this.path = null;
        this.key = this.key(this.parentId, name);
    }

    protected String key(String parentId, QPathEntry[] pathEntries) {
        return this.key(parentId, pathEntries[pathEntries.length - 1]);
    }

    protected String key(String parentId, QPathEntry name) {
        StringBuilder sk = new StringBuilder();
        sk.append(parentId != null ? parentId : Constants.ROOT_PARENT_UUID);
        sk.append(name.getAsString(true));
        return sk.toString();
    }

    public boolean equals(Object obj) {
        if (this.key.hashCode() == obj.hashCode() && obj instanceof CacheQPath) {
            return this.key.equals(((CacheQPath)obj).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return (this.parentId != null ? this.parentId : Constants.ROOT_PARENT_UUID) + (this.path != null ? this.path.getEntries()[this.path.getEntries().length - 1] : "null") + ", " + this.key;
    }

    protected String getParentId() {
        return this.parentId;
    }

    protected QPath getQPath() {
        return this.path;
    }
}

