/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFileStreamValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.SQLExceptionHandler;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCStorageConnection
extends DBConstants
implements WorkspaceStorageConnection {
    protected static Log log = ExoLogger.getLogger((String)"jcr.JDBCStorageConnection");
    public static final int I_CLASS_NODE = 1;
    public static final int I_CLASS_PROPERTY = 2;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected final int maxBufferSize;
    protected final File swapDirectory;
    protected final FileCleaner swapCleaner;
    protected final Connection dbConnection;
    protected final String containerName;
    protected final SQLExceptionHandler exceptionHandler;

    protected JDBCStorageConnection(Connection dbConnection, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        this.valueStorageProvider = valueStorageProvider;
        this.maxBufferSize = maxBufferSize;
        this.swapDirectory = swapDirectory;
        this.swapCleaner = swapCleaner;
        this.containerName = containerName;
        this.dbConnection = dbConnection;
        if (dbConnection.getAutoCommit()) {
            dbConnection.setAutoCommit(false);
        }
        this.prepareQueries();
        this.exceptionHandler = new SQLExceptionHandler(containerName, this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JDBCStorageConnection) {
            JDBCStorageConnection another = (JDBCStorageConnection)obj;
            return this.getJdbcConnection() == another.getJdbcConnection();
        }
        return false;
    }

    public Connection getJdbcConnection() {
        return this.dbConnection;
    }

    protected abstract void prepareQueries() throws SQLException;

    protected abstract String getInternalId(String var1);

    protected abstract String getIdentifier(String var1);

    protected void checkIfOpened() throws IllegalStateException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    @Override
    public boolean isOpened() {
        try {
            return !this.dbConnection.isClosed();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public final void rollback() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.dbConnection.rollback();
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public final void commit() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.dbConnection.commit();
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addNodeRecord(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Node add. Database error: " + e));
            }
            this.exceptionHandler.handleAddException(e, data);
        }
    }

    @Override
    public void add(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addPropertyRecord(data);
            if (data.getType() == 9) {
                try {
                    this.addReference(data);
                }
                catch (IOException e) {
                    throw new RepositoryException("Can't read REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
                }
            }
            this.addValues(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property added " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property add. IO error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, data);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property add. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, data);
        }
    }

    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            if (this.renameNode(data) <= 0) {
                throw new JCRInvalidItemStateException("(rename) Node " + data.getQPath().getAsString() + " " + data.getIdentifier() + " is not renamed. Probably was deleted by another session ", data.getIdentifier(), 32);
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property add. IO error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, data);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property add. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleAddException(e, data);
        }
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Node " + data.getQPath().getAsString() + " " + data.getIdentifier() + " not found. Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Node remove. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void delete(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getIdentifier());
        try {
            this.deleteExternalValues(cid, data);
            this.deleteValues(cid);
            this.deleteReference(cid);
            int nc = this.deleteItemByIdentifier(cid);
            if (nc <= 0) {
                throw new JCRInvalidItemStateException("(delete) Property " + data.getQPath().getAsString() + " " + data.getIdentifier() + " not found. Probably was deleted by another session ", data.getIdentifier(), 4);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property deleted " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property remove. IO error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property remove. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updateNodeByIdentifier(data.getPersistedVersion(), data.getQPath().getIndex(), data.getOrderNumber(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Node " + data.getQPath().getAsString() + " " + data.getIdentifier() + " is not updated. Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Node update. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    @Override
    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getIdentifier());
            if (this.updatePropertyByIdentifier(data.getPersistedVersion(), data.getType(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Property " + data.getQPath().getAsString() + " " + data.getIdentifier() + " is not updated. Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            try {
                this.deleteReference(cid);
                if (data.getType() == 9) {
                    this.addReference(data);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't update REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
            }
            this.deleteExternalValues(cid, data);
            this.deleteValues(cid);
            this.addValues(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property updated " + data.getQPath().getAsString() + ", " + data.getIdentifier() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data")));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property update. IO error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Property update. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet node = this.findChildNodesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            ArrayList<NodeData> childrens = new ArrayList<NodeData>();
            while (node.next()) {
                childrens.add((NodeData)this.itemData(parent.getQPath(), node, 1, parent.getACL()));
            }
            return childrens;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            while (prop.next()) {
                children.add((PropertyData)this.itemData(parent.getQPath(), prop, 2, null));
            }
            return children;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet prop = this.findChildPropertiesByParentIdentifier(this.getInternalId(parent.getIdentifier()));
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            while (prop.next()) {
                children.add(this.propertyData(parent.getQPath(), prop));
            }
            return children;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        return this.getItemByIdentifier(this.getInternalId(identifier));
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException, IllegalStateException {
        if (parentData != null) {
            return this.getItemByName(parentData, this.getInternalId(parentData.getIdentifier()), name);
        }
        return this.getItemByName(null, null, name);
    }

    @Override
    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet refProps = this.findReferences(this.getInternalId(nodeIdentifier));
            ArrayList<PropertyData> references = new ArrayList<PropertyData>();
            while (refProps.next()) {
                references.add((PropertyData)this.itemData(null, refProps, 2, null));
            }
            return references;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    protected ItemData getItemByIdentifier(String cid) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet item = null;
        try {
            item = this.findItemByIdentifier(cid);
            if (item.next()) {
                ItemData itemData = this.itemData(null, item, item.getInt("I_CLASS"), null);
                return itemData;
            }
            ItemData itemData = null;
            return itemData;
        }
        catch (SQLException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        finally {
            try {
                if (item != null) {
                    item.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)("getItemData() Error close resultset " + e.getMessage()));
            }
        }
    }

    protected ItemData getItemByName(NodeData parent, String parentId, QPathEntry name) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet item = null;
        try {
            item = this.findItemByName(parentId, name.getAsString(), name.getIndex());
            if (item.next()) {
                ItemData itemData = this.itemData(parent.getQPath(), item, item.getInt("I_CLASS"), parent.getACL());
                return itemData;
            }
            ItemData itemData = null;
            return itemData;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                if (item != null) {
                    item.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)("getItemData() Error close resultset " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String caid = cpid;
        do {
            ResultSet parent = null;
            try {
                parent = this.findItemByIdentifier(caid);
                if (!parent.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                QPathEntry qpe = new QPathEntry(InternalQName.parse(parent.getString("NAME")), parent.getInt("I_INDEX"));
                qrpath.add(qpe);
                caid = parent.getString("PARENT_ID");
            }
            finally {
                parent.close();
            }
        } while (!caid.equals(Constants.ROOT_PARENT_UUID));
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    private List<AccessControlEntry> traverseACLPermissions(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naMixins.hasPrivilegeable()) {
                return this.readACLPermisions(caid);
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        throw new IllegalACLException("Can not find permissions for a node with id " + this.getIdentifier(cpid));
    }

    protected String findParentId(String cid) throws SQLException, RepositoryException {
        ResultSet pidrs = this.findItemByIdentifier(cid);
        try {
            if (pidrs.next()) {
                String string = pidrs.getString("PARENT_ID");
                return string;
            }
            throw new RepositoryException("Item not found id: " + this.getIdentifier(cid));
        }
        finally {
            pidrs.close();
        }
    }

    private String traverseACLOwner(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naMixins.hasOwneable()) {
                return this.readACLOwner(caid);
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        throw new IllegalACLException("Can not find owner for a node with id " + this.getIdentifier(cpid));
    }

    private AccessControlList traverseACL(String cpid) throws SQLException, IllegalACLException, IllegalNameException, RepositoryException {
        String naOwner = null;
        List<AccessControlEntry> naPermissions = null;
        String caid = cpid;
        while (!caid.equals(Constants.ROOT_PARENT_UUID)) {
            MixinInfo naMixins = this.readMixins(caid);
            if (naOwner == null && naMixins.hasOwneable()) {
                naOwner = this.readACLOwner(caid);
                if (naPermissions != null) break;
            }
            if (naPermissions == null && naMixins.hasPrivilegeable()) {
                naPermissions = this.readACLPermisions(caid);
                if (naOwner != null) break;
            }
            if (naMixins.parentId == null) {
                caid = this.findParentId(caid);
                continue;
            }
            caid = naMixins.parentId;
        }
        if (naOwner != null && naPermissions != null) {
            return new AccessControlList(naOwner, naPermissions);
        }
        if (naOwner == null && naPermissions == null) {
            return new AccessControlList();
        }
        throw new IllegalACLException("ACL is not found for node with id " + this.getIdentifier(cpid) + " or for its ancestors. But repository is ACL enabled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QPath traverseQPath_SP_PGSQL(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        if (cpid == null) {
            return null;
        }
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        PreparedStatement cstmt = null;
        try {
            cstmt = this.dbConnection.prepareStatement("select * from get_qpath(?) AS (id varchar, name varchar, parent_id varchar, i_index int)");
            cstmt.setString(1, cpid);
            ResultSet parent = cstmt.executeQuery();
            while (parent.next()) {
                QPathEntry qpe = new QPathEntry(InternalQName.parse(parent.getString("NAME")), parent.getInt("I_INDEX"));
                qrpath.add(qpe);
            }
            if (qrpath.size() <= 0) {
                throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(cpid));
            }
        }
        finally {
            if (cstmt != null) {
                cstmt.close();
            }
        }
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    private ItemData itemData(QPath parentPath, ResultSet item, int itemClass, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        try {
            if (itemClass == 1) {
                int cindex = item.getInt("I_INDEX");
                int cnordernumb = item.getInt("N_ORDER_NUM");
                return this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, parentACL);
            }
            int cptype = item.getInt("P_TYPE");
            boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
            return this.loadPropertyRecord(parentPath, cname, cid, cpid, cversion, cptype, cpmultivalued);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build item path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + (Object)((Object)e));
        }
    }

    private PropertyData propertyData(QPath parentPath, ResultSet item) throws RepositoryException, SQLException, IOException {
        String cid = item.getString("ID");
        String cname = item.getString("NAME");
        int cversion = item.getInt("VERSION");
        String cpid = item.getString("PARENT_ID");
        int cptype = item.getInt("P_TYPE");
        boolean cpmultivalued = item.getBoolean("P_MULTIVALUED");
        try {
            InternalQName qname = InternalQName.parse(cname);
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, qname);
            PersistedPropertyData pdata = new PersistedPropertyData(this.getIdentifier(cid), qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued);
            pdata.setValues(new ArrayList());
            return pdata;
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("FATAL: Can't build property path for name " + cname + " id: " + this.getIdentifier(cid) + ". " + (Object)((Object)e));
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MixinInfo readMixins(String cid) throws SQLException, IllegalNameException {
        ResultSet mtrs = this.findPropertyByName(cid, Constants.JCR_MIXINTYPES.getAsString());
        try {
            ArrayList<InternalQName> mts = null;
            boolean owneable = false;
            boolean privilegeable = false;
            if (mtrs.next()) {
                mts = new ArrayList<InternalQName>();
                do {
                    byte[] mxnb;
                    if ((mxnb = mtrs.getBytes("DATA")) == null) continue;
                    InternalQName mxn = InternalQName.parse(new String(mxnb));
                    mts.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                } while (mtrs.next());
            }
            MixinInfo mixinInfo = new MixinInfo(mts, owneable, privilegeable);
            return mixinInfo;
        }
        finally {
            mtrs.close();
        }
    }

    protected List<AccessControlEntry> readACLPermisions(String cid) throws SQLException, IllegalACLException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        ResultSet exoPerm = this.findPropertyByName(cid, Constants.EXO_PERMISSIONS.getAsString());
        try {
            if (exoPerm.next()) {
                do {
                    StringTokenizer parser = new StringTokenizer(new String(exoPerm.getBytes("DATA")), " ");
                    naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
                } while (exoPerm.next());
                ArrayList<AccessControlEntry> arrayList = naPermissions;
                return arrayList;
            }
            throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
        }
        finally {
            exoPerm.close();
        }
    }

    protected String readACLOwner(String cid) throws SQLException, IllegalACLException {
        ResultSet exoOwner = this.findPropertyByName(cid, Constants.EXO_OWNER.getAsString());
        try {
            if (exoOwner.next()) {
                String string = new String(exoOwner.getBytes("DATA"));
                return string;
            }
            throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
        }
        finally {
            exoOwner.close();
        }
    }

    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        try {
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex);
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex);
                parentCid = cpid;
            }
            try {
                ResultSet ptProp = this.findPropertyByName(cid, Constants.JCR_PRIMARYTYPE.getAsString());
                if (!ptProp.next()) {
                    throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + cid + ", container " + this.containerName, null);
                }
                byte[] data = ptProp.getBytes("DATA");
                InternalQName ptName = InternalQName.parse(new String(data != null ? data : new byte[]{}));
                MixinInfo mixins = this.readMixins(cid);
                AccessControlList acl = mixins.hasOwneable() ? (mixins.hasPrivilegeable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid), null))) : (mixins.hasPrivilegeable() ? (mixins.hasOwneable() ? new AccessControlList(this.readACLOwner(cid), this.readACLPermisions(cid)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid)) : new AccessControlList(null, this.readACLPermisions(cid)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                return new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mixins.mixinNames(), acl);
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected PersistedPropertyData loadPropertyRecord(QPath parentPath, String cname, String cid, String cpid, int cversion, int cptype, boolean cpmultivalued) throws RepositoryException, SQLException, IOException {
        try {
            QPath qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
            PersistedPropertyData pdata = new PersistedPropertyData(this.getIdentifier(cid), qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued);
            pdata.setValues(this.readValues(cid, pdata));
            return pdata;
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Deprecated
    private boolean isAccessControllable(InternalQName[] mixinNames) {
        for (int i = 0; i < mixinNames.length; ++i) {
            if (!mixinNames[i].getAsString().equals("[http://www.exoplatform.com/jcr/exo/1.0]accessControllable") && !mixinNames[i].getAsString().equals("[http://www.exoplatform.com/jcr/exo/1.0]privilegeable")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExternalValues(String cid, PropertyData pdata) throws IOException, ValueDataNotFoundException {
        block8: {
            try {
                ResultSet valueRecords = this.findValuesByPropertyId(cid);
                try {
                    if (!valueRecords.next()) break block8;
                    String storageId = valueRecords.getString("STORAGE_DESC");
                    if (valueRecords.wasNull()) break block8;
                    ValueIOChannel channel = this.valueStorageProvider.getChannel(storageId, pdata);
                    try {
                        channel.delete(pdata.getIdentifier());
                    }
                    finally {
                        channel.close();
                    }
                }
                finally {
                    valueRecords.close();
                }
            }
            catch (SQLException e) {
                String msg = "Can't read value data of property with id " + cid + ", error:" + e;
                log.error((Object)msg, (Throwable)e);
                throw new IOException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueData> readValues(String cid, PropertyData pdata) throws IOException, ValueDataNotFoundException {
        ArrayList<ValueData> data = new ArrayList<ValueData>();
        try {
            ResultSet valueRecords = this.findValuesByPropertyId(cid);
            try {
                while (valueRecords.next()) {
                    int orderNum = valueRecords.getInt("ORDER_NUM");
                    String storageId = valueRecords.getString("STORAGE_DESC");
                    ValueData vdata = valueRecords.wasNull() ? this.readValueData(cid, orderNum, pdata.getPersistedVersion()) : this.readValueData(pdata, orderNum, storageId);
                    data.add(vdata);
                }
            }
            finally {
                valueRecords.close();
            }
        }
        catch (SQLException e) {
            String msg = "Can't read value data of property with id " + cid + ", error:" + e;
            log.error((Object)msg, (Throwable)e);
            throw new IOException(msg);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValueData(PropertyData pdata, int orderNumber, String storageId) throws SQLException, IOException, ValueDataNotFoundException {
        ValueIOChannel channel = this.valueStorageProvider.getChannel(storageId, pdata);
        try {
            ValueData valueData = channel.read(pdata.getIdentifier(), orderNumber, this.maxBufferSize);
            return valueData;
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValueData(String cid, int orderNumber, int version) throws SQLException, IOException {
        SwapFile swapFile;
        byte[] buffer;
        block10: {
            ResultSet valueResultSet = null;
            buffer = new byte[]{};
            byte[] spoolBuffer = new byte[2048];
            int len = 0;
            OutputStream out = null;
            swapFile = null;
            try {
                int read;
                InputStream in;
                valueResultSet = this.findValueByPropertyIdOrderNumber(cid, orderNumber);
                if (!valueResultSet.next() || (in = valueResultSet.getBinaryStream("DATA")) == null) break block10;
                while ((read = in.read(spoolBuffer)) >= 0) {
                    if (out != null) {
                        out.write(spoolBuffer, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > this.maxBufferSize) {
                        swapFile = SwapFile.get(this.swapDirectory, cid + orderNumber + "." + version);
                        if (swapFile.isSpooled()) {
                            buffer = null;
                            break;
                        }
                        out = new FileOutputStream(swapFile);
                        out.write(buffer, 0, len);
                        out.write(spoolBuffer, 0, read);
                        buffer = null;
                        len += read;
                        continue;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(buffer, 0, newBuffer, 0, len);
                    System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                    buffer = newBuffer;
                    len += read;
                }
            }
            finally {
                if (valueResultSet != null) {
                    valueResultSet.close();
                }
                if (out != null) {
                    out.close();
                    swapFile.spoolDone();
                }
            }
        }
        if (buffer == null) {
            return new CleanableFileStreamValueData(swapFile, orderNumber, this.swapCleaner);
        }
        return new ByteArrayPersistedValueData(buffer, orderNumber);
    }

    protected void addValues(PropertyData data) throws IOException, SQLException {
        List<ValueData> vdata = data.getValues();
        for (int i = 0; i < vdata.size(); ++i) {
            ValueData vd = vdata.get(i);
            vd.setOrderNumber(i);
            ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel(data, i);
            InputStream stream = null;
            int streamLength = 0;
            String storageId = null;
            if (channel == null) {
                if (vd.isByteArray()) {
                    byte[] dataBytes = vd.getAsByteArray();
                    stream = new ByteArrayInputStream(dataBytes);
                    streamLength = dataBytes.length;
                } else {
                    stream = vd.getAsStream();
                    streamLength = stream.available();
                }
            } else {
                channel.write(data.getIdentifier(), vd);
                storageId = channel.getStorageId();
            }
            this.addValueData(this.getInternalId(data.getIdentifier()), i, stream, streamLength, storageId);
        }
    }

    protected abstract int addNodeRecord(NodeData var1) throws SQLException;

    protected abstract int addPropertyRecord(PropertyData var1) throws SQLException;

    protected abstract ResultSet findItemByIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findPropertyByName(String var1, String var2) throws SQLException;

    protected abstract ResultSet findItemByName(String var1, String var2, int var3) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifier(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifier(String var1) throws SQLException;

    protected abstract int addReference(PropertyData var1) throws SQLException, IOException;

    protected abstract int renameNode(NodeData var1) throws SQLException, IOException;

    protected abstract int deleteReference(String var1) throws SQLException;

    protected abstract ResultSet findReferences(String var1) throws SQLException;

    protected abstract int deleteItemByIdentifier(String var1) throws SQLException;

    protected abstract int updateNodeByIdentifier(int var1, int var2, int var3, String var4) throws SQLException;

    protected abstract int updatePropertyByIdentifier(int var1, int var2, String var3) throws SQLException;

    protected abstract int addValueData(String var1, int var2, InputStream var3, int var4, String var5) throws SQLException, IOException;

    protected abstract int deleteValues(String var1) throws SQLException;

    protected abstract ResultSet findValuesByPropertyId(String var1) throws SQLException;

    protected abstract ResultSet findValueByPropertyIdOrderNumber(String var1, int var2) throws SQLException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MixinInfo {
        static final int OWNEABLE = 1;
        static final int PRIVILEGEABLE = 2;
        static final int OWNEABLE_PRIVILEGEABLE = 3;
        final List<InternalQName> mixinTypes;
        final boolean owneable;
        final boolean privilegeable;
        final String parentId;

        MixinInfo(List<InternalQName> mixinTypes, boolean owneable, boolean privilegeable) {
            this.parentId = null;
            this.mixinTypes = mixinTypes;
            this.owneable = owneable;
            this.privilegeable = privilegeable;
        }

        InternalQName[] mixinNames() {
            if (this.mixinTypes != null) {
                InternalQName[] mns = new InternalQName[this.mixinTypes.size()];
                this.mixinTypes.toArray(mns);
                return mns;
            }
            return new InternalQName[0];
        }

        boolean hasPrivilegeable() {
            return this.privilegeable;
        }

        boolean hasOwneable() {
            return this.owneable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemLocationInfo {
        final QPath qpath;
        final List<String> ancestors;
        final String itemId;

        ItemLocationInfo(QPath qpath, List<String> ancestors, String itemId) {
            this.qpath = qpath;
            this.ancestors = ancestors;
            this.itemId = itemId;
        }
    }
}

