/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.jcr.DataMapper;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.picocontainer.Startable;

public class DataStorageImpl
implements DataStorage,
Startable {
    private static final String PORTAL_DATA = "MainPortalData";
    private static final String USER_DATA = "UserPortalData";
    private static final String GROUP_DATA = "SharedPortalData";
    private static final String PORTAL_CONFIG_FILE_NAME = "portal-xml";
    private static final String NAVIGATION_CONFIG_FILE_NAME = "navigation-xml";
    private static final String WIDGETS_CONFIG_FILE_NAME = "widgets-xml";
    private static final String PAGE_SET_NODE = "pages";
    private static final String PORTLET_PREFERENCES_SET_NODE = "portletPreferences";
    private RegistryService regService_;
    private DataMapper mapper_ = new DataMapper();

    public DataStorageImpl(RegistryService service) throws Exception {
        this.regService_ = service;
    }

    public PortalConfig getPortalConfig(String portalName) throws Exception {
        RegistryEntry portalEntry;
        String portalPath = this.getApplicationRegistryPath("portal", portalName) + "/" + PORTAL_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            portalEntry = this.regService_.getEntry(sessionProvider, portalPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        PortalConfig config = this.mapper_.toPortalConfig(portalEntry.getDocument());
        sessionProvider.close();
        return config;
    }

    public void create(PortalConfig config) throws Exception {
        String portalAppPath = this.getApplicationRegistryPath("portal", config.getName());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry portalEntry = new RegistryEntry(PORTAL_CONFIG_FILE_NAME);
        this.mapper_.map(portalEntry.getDocument(), config);
        this.regService_.createEntry(sessionProvider, portalAppPath, portalEntry);
        sessionProvider.close();
    }

    public void save(PortalConfig config) throws Exception {
        String portalAppPath = this.getApplicationRegistryPath("portal", config.getName());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry portalEntry = this.regService_.getEntry(sessionProvider, portalAppPath + "/" + PORTAL_CONFIG_FILE_NAME);
        this.mapper_.map(portalEntry.getDocument(), config);
        this.regService_.recreateEntry(sessionProvider, portalAppPath, portalEntry);
        sessionProvider.close();
    }

    public void remove(PortalConfig config) throws Exception {
        String portalPath = this.getApplicationRegistryPath("portal", config.getName()) + "/" + PORTAL_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, portalPath);
        sessionProvider.close();
    }

    public Page getPage(String pageId) throws Exception {
        RegistryEntry pageEntry;
        String[] fragments = pageId.split("::");
        if (fragments.length < 3) {
            throw new Exception("Invalid PageId: [" + pageId + "]");
        }
        String pagePath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + PAGE_SET_NODE + "/" + fragments[2];
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            pageEntry = this.regService_.getEntry(sessionProvider, pagePath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Page page = this.mapper_.toPageConfig(pageEntry.getDocument());
        sessionProvider.close();
        return page;
    }

    public void create(Page page) throws Exception {
        String[] fragments = page.getPageId().split("::");
        String pageSetPath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + PAGE_SET_NODE;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry pageEntry = new RegistryEntry(page.getName());
        this.mapper_.map(pageEntry.getDocument(), page);
        this.regService_.createEntry(sessionProvider, pageSetPath, pageEntry);
        sessionProvider.close();
    }

    public void save(Page page) throws Exception {
        String[] fragments = page.getPageId().split("::");
        String pageSetPath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + PAGE_SET_NODE;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry pageEntry = this.regService_.getEntry(sessionProvider, pageSetPath + "/" + page.getName());
        this.mapper_.map(pageEntry.getDocument(), page);
        this.regService_.recreateEntry(sessionProvider, pageSetPath, pageEntry);
        sessionProvider.close();
    }

    public void remove(Page page) throws Exception {
        String[] fragments = page.getPageId().split("::");
        String pagePath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + PAGE_SET_NODE + "/" + page.getName();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, pagePath);
        sessionProvider.close();
    }

    public PageNavigation getPageNavigation(String id) throws Exception {
        RegistryEntry navigationEntry;
        String[] fragments = id.split("::");
        if (fragments.length < 2) {
            throw new Exception("Invalid PageNavigation Id: [" + id + "]");
        }
        String navigationPath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + NAVIGATION_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            navigationEntry = this.regService_.getEntry(sessionProvider, navigationPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        PageNavigation navigation = this.mapper_.toPageNavigation(navigationEntry.getDocument());
        sessionProvider.close();
        return navigation;
    }

    public void create(PageNavigation navigation) throws Exception {
        String appRegPath = this.getApplicationRegistryPath(navigation.getOwnerType(), navigation.getOwnerId());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry NavigationEntry = new RegistryEntry(NAVIGATION_CONFIG_FILE_NAME);
        this.mapper_.map(NavigationEntry.getDocument(), navigation);
        this.regService_.createEntry(sessionProvider, appRegPath, NavigationEntry);
        sessionProvider.close();
    }

    public void save(PageNavigation navigation) throws Exception {
        String appRegPath = this.getApplicationRegistryPath(navigation.getOwnerType(), navigation.getOwnerId());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry navigationEntry = this.regService_.getEntry(sessionProvider, appRegPath + "/" + NAVIGATION_CONFIG_FILE_NAME);
        this.mapper_.map(navigationEntry.getDocument(), navigation);
        this.regService_.recreateEntry(sessionProvider, appRegPath, navigationEntry);
        sessionProvider.close();
    }

    public void remove(PageNavigation navigation) throws Exception {
        String navigationPath = this.getApplicationRegistryPath(navigation.getOwnerType(), navigation.getOwnerId()) + "/" + NAVIGATION_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, navigationPath);
        sessionProvider.close();
    }

    public Widgets getWidgets(String id) throws Exception {
        RegistryEntry widgetsEntry;
        String[] fragments = id.split("::");
        if (fragments.length < 2) {
            throw new Exception("Invalid Widgets Id: [" + id + "]");
        }
        String widgetsPath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + WIDGETS_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            widgetsEntry = this.regService_.getEntry(sessionProvider, widgetsPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        Widgets widgets = this.mapper_.toWidgets(widgetsEntry.getDocument());
        sessionProvider.close();
        return widgets;
    }

    public void create(Widgets widgets) throws Exception {
        String appRegPath = this.getApplicationRegistryPath(widgets.getOwnerType(), widgets.getOwnerId());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry widgetsEntry = new RegistryEntry(WIDGETS_CONFIG_FILE_NAME);
        this.mapper_.map(widgetsEntry.getDocument(), widgets);
        this.regService_.createEntry(sessionProvider, appRegPath, widgetsEntry);
        sessionProvider.close();
    }

    public void save(Widgets widgets) throws Exception {
        String appRegPath = this.getApplicationRegistryPath(widgets.getOwnerType(), widgets.getOwnerId());
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RegistryEntry widgetsEntry = this.regService_.getEntry(sessionProvider, appRegPath + "/" + WIDGETS_CONFIG_FILE_NAME);
        this.mapper_.map(widgetsEntry.getDocument(), widgets);
        this.regService_.recreateEntry(sessionProvider, appRegPath, widgetsEntry);
        sessionProvider.close();
    }

    public void remove(Widgets widgets) throws Exception {
        String widgetsPath = this.getApplicationRegistryPath(widgets.getOwnerType(), widgets.getOwnerId()) + "/" + WIDGETS_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, widgetsPath);
        sessionProvider.close();
    }

    public PortletPreferences getPortletPreferences(WindowID windowID) throws Exception {
        RegistryEntry portletPreferencesEntry;
        String[] fragments = windowID.getOwner().split("#");
        if (fragments.length < 2) {
            throw new Exception("Invalid WindowID: [" + windowID + "]");
        }
        ExoWindowID exoWindowID = (ExoWindowID)windowID;
        String name = exoWindowID.getPersistenceId().replace('/', '_').replace(':', '_').replace('#', '_');
        String portletPreferencesPath = this.getApplicationRegistryPath(fragments[0], fragments[1]) + "/" + PORTLET_PREFERENCES_SET_NODE + "/" + name;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            portletPreferencesEntry = this.regService_.getEntry(sessionProvider, portletPreferencesPath);
        }
        catch (PathNotFoundException ie) {
            sessionProvider.close();
            return null;
        }
        PortletPreferences portletPreferences = this.mapper_.toPortletPreferences(portletPreferencesEntry.getDocument());
        sessionProvider.close();
        return portletPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PortletPreferences portletPreferences) throws Exception {
        String name = portletPreferences.getWindowId().replace('/', '_').replace(':', '_').replace('#', '_');
        String portletPreferencesSet = this.getApplicationRegistryPath(portletPreferences.getOwnerType(), portletPreferences.getOwnerId()) + "/" + PORTLET_PREFERENCES_SET_NODE;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, portletPreferencesSet + "/" + name);
            this.mapper_.map(entry.getDocument(), portletPreferences);
            this.regService_.recreateEntry(sessionProvider, portletPreferencesSet, entry);
        }
        catch (PathNotFoundException ie) {
            RegistryEntry entry = new RegistryEntry(name);
            this.mapper_.map(entry.getDocument(), portletPreferences);
            this.regService_.createEntry(sessionProvider, portletPreferencesSet, entry);
        }
        finally {
            sessionProvider.close();
        }
    }

    public void remove(PortletPreferences portletPreferences) throws Exception {
        String name = portletPreferences.getWindowId().replace('/', '_').replace(':', '_').replace('#', '_');
        String portletPreferencesPath = this.getApplicationRegistryPath(portletPreferences.getOwnerType(), portletPreferences.getOwnerId()) + "/" + PORTLET_PREFERENCES_SET_NODE + "/" + name;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.regService_.removeEntry(sessionProvider, portletPreferencesPath);
        sessionProvider.close();
    }

    public PageList find(Query q) throws Exception {
        return this.find(q, (Comparator)null);
    }

    public PageList find(Query q, Comparator sortComparator) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        StringBuilder builder = new StringBuilder("select * from exo:registryEntry");
        String registryNodePath = this.regService_.getRegistry(sessionProvider).getNode().getPath();
        this.generateScript(builder, "jcr:path", registryNodePath + "/%");
        this.generateScript(builder, "exo:dataType", q.getClassType().getSimpleName());
        this.generateScript(builder, "exo:name", q.getName());
        this.generateScript(builder, "exo:ownerType", q.getOwnerType());
        this.generateScript(builder, "exo:ownerId", q.getOwnerId());
        Session session = this.regService_.getRegistry(sessionProvider).getNode().getSession();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        javax.jcr.query.Query query = queryManager.createQuery(builder.toString(), "sql");
        QueryResult result = query.execute();
        ArrayList list = new ArrayList();
        NodeIterator itr = result.getNodes();
        while (itr.hasNext()) {
            Node node = itr.nextNode();
            String entryPath = node.getPath().substring(registryNodePath.length() + 1);
            RegistryEntry entry = this.regService_.getEntry(sessionProvider, entryPath);
            list.add(this.mapper_.fromDocument(entry.getDocument(), q.getClassType()));
        }
        sessionProvider.close();
        if (sortComparator != null) {
            Collections.sort(list, sortComparator);
        }
        return new ObjectPageList(list, 10);
    }

    public void start() {
    }

    public void stop() {
    }

    private void generateScript(StringBuilder sql, String name, String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        if (sql.indexOf(" where") < 0) {
            sql.append(" where ");
        } else {
            sql.append(" and ");
        }
        value = value.replace('*', '%');
        sql.append(name).append(" like '").append(value).append("'");
    }

    private String getApplicationRegistryPath(String ownerType, String ownerId) {
        String path = "";
        if ("portal".equals(ownerType)) {
            path = "exo:applications/MainPortalData/" + ownerId;
        } else if ("user".equals(ownerType)) {
            path = "exo:users/" + ownerId + "/" + USER_DATA;
        } else if ("group".equals(ownerType)) {
            if (ownerId.charAt(0) != '/') {
                ownerId = "/" + ownerId;
            }
            path = "exo:groups" + ownerId + "/" + GROUP_DATA;
        }
        return path;
    }
}

