/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.exoplatform.commons.utils.ExoEnumeration;
import org.exoplatform.services.portletcontainer.pci.model.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoPortletPreferences
extends HashMap<String, Preference>
implements PortletPreferences,
Serializable {
    private String preferencesValidator;
    private String id;

    public final Map<String, String[]> getMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : this.keySet()) {
            result.put(key, this.getValues(key, null));
        }
        return Collections.unmodifiableMap(result);
    }

    public final boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return false;
        }
        return preference.isReadOnly();
    }

    public final String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        return preference.getValue(def);
    }

    public final String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return def;
        }
        return preference.getValues(key, def);
    }

    public final void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            preference = new Preference();
            preference.setName(key);
            this.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        if (value == null) {
            return;
        }
        preference.addValue(value);
    }

    public final void setValues(String key, String[] value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            preference = new Preference();
            preference.setName(key);
            this.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        if (value == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String element : value) {
            list.add(element);
        }
        preference.setValues(list);
    }

    public final Enumeration<String> getNames() {
        return new ExoEnumeration(this.keySet().iterator());
    }

    public final void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return;
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        preference.clear();
    }

    public final void store() throws IOException, ValidatorException {
        throw new Error("NOT SUPPORT");
    }

    public final void addPreference(Preference pref) {
        this.put(pref.getName(), pref);
    }

    public final String getPreferencesValidator() {
        return this.preferencesValidator;
    }

    public final void setPreferencesValidator(String preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String value) {
        this.id = value;
    }
}

