/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.skin.SkinConfig;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplicationLifecycle;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl", initParams={@ParamConfig(name="public.showControlWorkspace", value="true")}), @ComponentConfig(id="office", lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl", initParams={@ParamConfig(name="public.showControlWorkspace", value="false")})})
public class UIPortalApplication
extends UIApplication {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortalApplication");
    private boolean isEditting = false;
    private String nodePath_;
    public static final String UI_CONTROL_WS_ID = "UIControlWorkspace";
    public static final String UI_WORKING_WS_ID = "UIWorkingWorkspace";
    public static final String UI_MASK_WS_ID = "UIMaskWorkspace";
    private String skin_ = "Default";
    private UserPortalConfig userPortalConfig_;

    public UIPortalApplication(InitParams initParams) throws Exception {
        LocaleConfigService localeConfigService;
        LocaleConfig localeConfig;
        PortalRequestContext context = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
        context.setUIApplication(this);
        this.userPortalConfig_ = (UserPortalConfig)context.getAttribute(UserPortalConfig.class);
        if (this.userPortalConfig_ == null) {
            throw new Exception("Can't load user portal config");
        }
        if (context.getAccessPath() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Build a public portal");
            }
            this.initPublicPortal(context, initParams);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Build a private portal");
            }
            this.initPrivatePortal(context, context.getRemoteUser());
        }
        String currentSkin = this.userPortalConfig_.getPortalConfig().getSkin();
        if (currentSkin != null && currentSkin.trim().length() > 0) {
            this.skin_ = currentSkin;
        }
        if ((localeConfig = (localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(this.userPortalConfig_.getPortalConfig().getLocale())) == null) {
            localeConfig = localeConfigService.getDefaultLocaleConfig();
        }
        this.setLocale(localeConfig.getLocale());
        this.setOwner(context.getPortalOwner());
    }

    public void setEditting(boolean bln) {
        this.isEditting = bln;
    }

    public boolean isEditting() {
        return this.isEditting;
    }

    public Collection<String> getJavascriptURLs() {
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        return service.getAvailableScriptsPaths();
    }

    public String getSkin() {
        return this.skin_;
    }

    public void setSkin(String skin) {
        this.skin_ = skin;
    }

    public SkinConfig getSkin(String module) {
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        SkinConfig skinConfig = skinService.getSkin(module, this.skin_);
        if (skinConfig == null) {
            skinConfig = skinService.getSkin(module, "Default");
        }
        return skinConfig;
    }

    public List<SkinConfig> getPortletSkins() {
        SkinConfig skinConfig;
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        ArrayList uiportlets = new ArrayList();
        UIWorkspace uiWorkingWS = (UIWorkspace)this.getChildById(UI_WORKING_WS_ID);
        UIPortal uiPortal = (UIPortal)uiWorkingWS.getChild(UIPortal.class);
        uiPortal.findComponentOfType(uiportlets, UIPortlet.class);
        UIPortalToolPanel toolPanel = (UIPortalToolPanel)uiWorkingWS.getChild(UIPortalToolPanel.class);
        if (toolPanel != null && toolPanel.isRendered()) {
            toolPanel.findComponentOfType(uiportlets, UIPortlet.class);
        }
        if ("false".equals(System.getProperty("exo.product.developing")) && !this.isEditting) {
            ArrayList<UIPortlet> portletInPage = new ArrayList<UIPortlet>();
            ArrayList<String> portletInPortal = new ArrayList<String>();
            for (UIPortlet uiPortlet : uiportlets) {
                if (uiPortlet.isPortletInPortal()) {
                    String module = uiPortlet.getExoWindowID().getPortletApplicationName() + "/" + uiPortlet.getExoWindowID().getPortletName();
                    portletInPortal.add(module);
                    continue;
                }
                portletInPage.add(uiPortlet);
            }
            uiportlets = portletInPage;
            SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
            skinConfig = skinService.getPortalSkin(uiPortal.getName(), this.skin_, portletInPortal);
            if (skinConfig != null) {
                skins.add(skinConfig);
            }
        }
        for (UIPortlet uiPortlet : uiportlets) {
            String module = uiPortlet.getExoWindowID().getPortletApplicationName() + "/" + uiPortlet.getExoWindowID().getPortletName();
            skinConfig = this.getSkin(module);
            if (skinConfig == null) continue;
            skins.add(skinConfig);
        }
        return skins;
    }

    private void initPublicPortal(PortalRequestContext context, InitParams initParams) throws Exception {
        if ("true".equals(initParams.getParam("public.showControlWorkspace").getValue())) {
            this.addChild(UIControlWorkspace.class, UI_CONTROL_WS_ID, null);
        }
        this.addWorkingWorkspace(context);
    }

    private void initPrivatePortal(PortalRequestContext context, String remoteUser) throws Exception {
        UserACL acl = (UserACL)this.getApplicationComponent(UserACL.class);
        if (acl.hasAccessControlWorkspacePermission(remoteUser)) {
            this.addChild(UIControlWorkspace.class, UI_CONTROL_WS_ID, null);
        }
        this.addWorkingWorkspace(context);
    }

    private void addWorkingWorkspace(PortalRequestContext context) throws Exception {
        UIWorkspace uiWorkingWorkspace = (UIWorkspace)this.createUIComponent(UIWorkspace.class, UI_WORKING_WS_ID, null);
        UIPortal uiPortal = (UIPortal)this.createUIComponent(UIPortal.class, null, null);
        PortalDataMapper.toUIPortal(uiPortal, this.userPortalConfig_);
        uiWorkingWorkspace.addChild((UIComponent)uiPortal);
        ((UIPortalToolPanel)uiWorkingWorkspace.addChild(UIPortalToolPanel.class, null, null)).setRendered(false);
        this.addChild((UIComponent)uiWorkingWorkspace);
        this.addChild(UIMaskWorkspace.class, UI_MASK_WS_ID, null);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String nodePath = pcontext.getNodePath();
        if (nodePath == null) {
            super.processDecode(context);
            return;
        }
        if ((nodePath = nodePath.trim()).equals(this.nodePath_)) {
            super.processDecode(context);
            return;
        }
        this.nodePath_ = nodePath;
        UIPortal uiPortal = (UIPortal)this.findFirstComponentOfType(UIPortal.class);
        PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", null, this.nodePath_);
        uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
        super.processDecode(context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        if (!context.useAjax()) {
            super.processRender(context);
        } else {
            PortalRequestContext pcontext = (PortalRequestContext)context;
            List list = context.getUIComponentToUpdateByAjax();
            ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>(3);
            ArrayList<UIComponent> uiDataComponents = new ArrayList<UIComponent>(5);
            if (list != null) {
                for (UIComponent uicomponent : list) {
                    if (uicomponent instanceof UIPortlet) {
                        uiPortlets.add((UIPortlet)uicomponent);
                        continue;
                    }
                    uiDataComponents.add(uicomponent);
                }
            }
            w.write("<div class=\"PortalResponse\">");
            if (!context.getFullRender()) {
                for (UIPortlet uiPortlet : uiPortlets) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the Portlet " + uiPortlet.getWindowId()));
                    }
                    w.write("<div class=\"PortletResponse\" style=\"display: none\">");
                    w.append("<div class=\"PortletResponsePortletId\">" + uiPortlet.getExoWindowID().getUniqueID() + "</div>");
                    w.append("<div class=\"PortletResponsePortletTitle\"></div>");
                    w.append("<div class=\"PortletResponsePortletMode\"></div>");
                    w.append("<div class=\"PortletResponsePortletState\"></div>");
                    w.append("<div class=\"PortletResponseData\">");
                    uiPortlet.processRender(context);
                    w.append("</div>");
                    w.append("<div class=\"PortletResponseScript\"></div>");
                    w.write("</div>");
                }
            }
            w.write("<div class=\"PortalResponseData\">");
            for (UIComponent uicomponent : uiDataComponents) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AJAX call: Need to refresh the UI component " + uicomponent.getName()));
                }
                this.renderBlockToUpdate(uicomponent, context, w);
            }
            w.write("</div>");
            w.write("<div class=\"PortalResponseScript\">");
            w.write(pcontext.getJavascriptManager().getJavascript());
            w.write("eXo.core.Browser.onLoad();\n");
            w.write(pcontext.getJavascriptManager().getCustomizedOnLoadScript());
            String skin = this.getAddSkinScript(list);
            if (skin != null) {
                w.write(skin);
            }
            w.write("</div>");
            w.write("</div>");
        }
    }

    private String getAddSkinScript(List<UIComponent> updateComponents) {
        if (updateComponents == null) {
            return null;
        }
        ArrayList uiportlets = new ArrayList();
        for (UIComponent uicomponent : updateComponents) {
            if (!(uicomponent instanceof UIContainer)) continue;
            UIContainer uiContainer = (UIContainer)uicomponent;
            uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        for (UIPortlet uiPortlet : uiportlets) {
            String module = uiPortlet.getExoWindowID().getPortletApplicationName() + "/" + uiPortlet.getExoWindowID().getPortletName();
            SkinConfig skinConfig = skinService.getSkin(module, this.skin_);
            if (skinConfig == null && !"Default".equals(this.skin_)) {
                skinConfig = skinService.getSkin(module, "Default");
            }
            if (skinConfig == null) continue;
            skins.add(skinConfig);
        }
        StringBuilder b = new StringBuilder(1000);
        for (SkinConfig ele : skins) {
            b.append("eXo.core.Skin.addSkin('").append(ele.getId()).append("','").append(ele.getCSSPath()).append("');\n");
        }
        return b.toString();
    }

    public UserPortalConfig getUserPortalConfig() {
        return this.userPortalConfig_;
    }

    public void setUserPortalConfig(UserPortalConfig userPortalConfig) {
        this.userPortalConfig_ = userPortalConfig;
    }
}

