/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CompressData {
    private String base_;
    private List<DataInstance> datas_ = new ArrayList<DataInstance>();
    protected static final int EOF = -1;
    protected static final int BUFFER = 2048;

    public CompressData() {
    }

    public CompressData(String base) {
        this.base_ = base;
    }

    private String getBase() {
        return this.base_;
    }

    public void addFile(String entryName, File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            this.datas_.add(new InputStreamDataInstance(entryName, is));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void addDir(File srcDir) {
        if (srcDir.isFile()) {
            this.addFile(srcDir.getName(), srcDir);
        } else {
            this.datas_.add(new FileDataInstance(srcDir.getName(), srcDir));
        }
    }

    public void addInputStream(String entryName, InputStream is) throws Exception {
        this.datas_.add(new InputStreamDataInstance(entryName, is));
    }

    public void createZipFile(String fileName) throws Exception {
        File fileZip = new File(fileName + ".zip");
        FileOutputStream out = new FileOutputStream(fileZip);
        ZipOutputStream zos = new ZipOutputStream(out);
        int size = this.datas_.size();
        byte[] InputData = new byte[2048];
        if (size < 0) {
            throw new Exception("Data size is null");
        }
        for (int i = 0; i < size; ++i) {
            DataInstance di = this.datas_.get(i);
            if (di instanceof InputStreamDataInstance) {
                int len;
                InputStream is = di.getInputStream();
                zos.putNextEntry(new ZipEntry(di.getEntryName()));
                while ((len = is.read(InputData)) != -1) {
                    zos.write(InputData, 0, len);
                }
                zos.closeEntry();
                continue;
            }
            if (!(di instanceof FileDataInstance)) continue;
            di.getZipOut(true, zos);
        }
        zos.close();
        out.close();
    }

    public void createZip(OutputStream os) throws Exception {
        int size = this.datas_.size();
        if (size == 0) {
            throw new Exception("Data is null");
        }
        for (int i = 0; i < size; ++i) {
            int len;
            InputStream is;
            DataInstance di = this.datas_.get(i);
            if (di instanceof InputStreamDataInstance) {
                int len2;
                is = di.getInputStream();
                ZipOutputStream zos = new ZipOutputStream(os);
                zos.putNextEntry(new ZipEntry(di.getEntryName()));
                byte[] InputData = new byte[2048];
                while ((len2 = is.read(InputData)) != -1) {
                    zos.write(InputData, 0, len2);
                }
                zos.closeEntry();
                zos.close();
                continue;
            }
            if (!(di instanceof FileDataInstance)) continue;
            di.setType("Zip");
            is = di.getInputStream();
            byte[] data = new byte[2048];
            while ((len = is.read(data)) != -1) {
                os.write(data, 0, len);
            }
            is.close();
        }
        os.close();
    }

    public void createJarFile(String fileName) throws Exception {
        File fileZip = new File(fileName + ".jar");
        FileOutputStream out = new FileOutputStream(fileZip);
        JarOutputStream jos = new JarOutputStream(out);
        int size = this.datas_.size();
        if (size < 0) {
            throw new Exception("Data size is null");
        }
        for (int i = 0; i < size; ++i) {
            DataInstance di = this.datas_.get(i);
            if (di instanceof InputStreamDataInstance) {
                int len;
                String entryName = di.getEntryName();
                InputStream is = di.getInputStream();
                jos.putNextEntry(new ZipEntry(entryName));
                byte[] InputData = new byte[2048];
                while ((len = is.read(InputData)) != -1) {
                    jos.write(InputData, 0, len);
                }
                jos.closeEntry();
                continue;
            }
            if (!(di instanceof FileDataInstance)) continue;
            di.getJarOut(true, jos);
        }
        jos.close();
        out.close();
    }

    public void createJar(OutputStream os) throws Exception {
        int size = this.datas_.size();
        if (size == 0) {
            throw new Exception("Data is null");
        }
        for (int i = 0; i < size; ++i) {
            int len;
            InputStream is;
            DataInstance di = this.datas_.get(i);
            if (di instanceof InputStreamDataInstance) {
                int len2;
                is = di.getInputStream();
                JarOutputStream jos = new JarOutputStream(os);
                jos.putNextEntry(new ZipEntry(di.getEntryName()));
                byte[] InputData = new byte[2048];
                while ((len2 = is.read(InputData)) != -1) {
                    jos.write(InputData, 0, len2);
                }
                jos.closeEntry();
                jos.close();
                is.close();
                continue;
            }
            if (!(di instanceof FileDataInstance)) continue;
            di.setType("Jar");
            is = di.getInputStream();
            byte[] data = new byte[2048];
            while ((len = is.read(data)) != -1) {
                os.write(data, 0, len);
            }
            is.close();
        }
        os.close();
    }

    public void cleanDataInstance() {
        int count = this.datas_.size();
        for (int i = 0; i < count; ++i) {
            this.datas_.remove(i);
        }
    }

    public static class InputStreamDataInstance
    extends DataInstance {
        private InputStream is_;

        public InputStreamDataInstance(String entryName, InputStream is) {
            this.entryName_ = entryName;
            this.is_ = is;
        }

        public InputStream getInputStream() {
            return this.is_;
        }

        public void getJarOut(boolean containParent, JarOutputStream jos) throws Exception {
        }

        public void getZipOut(boolean containParent, ZipOutputStream zos) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileDataInstance
    extends DataInstance {
        private File file_;

        public FileDataInstance(String entryName, File file) {
            this.entryName_ = entryName;
            this.file_ = file;
        }

        @Override
        public InputStream getInputStream() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.getType() == "Zip") {
                ZipOutputStream zos = new ZipOutputStream(baos);
                try {
                    this.getZipOut(true, zos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    JarOutputStream jos = new JarOutputStream(baos);
                    this.getJarOut(true, jos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return is;
        }

        @Override
        public void getJarOut(boolean containParent, JarOutputStream jos) throws Exception {
            String path = this.file_.getAbsolutePath();
            FileInputStream bufInput = null;
            List<File> list = this.listFile(this.file_);
            if (this.file_.isDirectory()) {
                list.remove(this.file_);
            }
            if (list == null || list.size() < 1) {
                throw new Exception("nothing in the list");
            }
            for (File f : list) {
                String filePath = f.getAbsolutePath();
                if (filePath.startsWith(path)) {
                    filePath = containParent && this.file_.isDirectory() ? this.file_.getName() + File.separator + filePath.substring(path.length() + 1) : (this.file_.isDirectory() ? filePath.substring(path.length() + 1) : this.file_.getName());
                }
                if (f.isFile()) {
                    bufInput = new FileInputStream(f);
                } else {
                    filePath = filePath + "/";
                }
                this.addToArchive(jos, (InputStream)bufInput, filePath);
            }
        }

        private List<File> listFile(File dir) {
            final ArrayList<File> list = new ArrayList<File>();
            if (dir.isFile()) {
                list.add(dir);
                return list;
            }
            dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        list.addAll(FileDataInstance.this.listFile(f));
                    }
                    list.add(f);
                    return true;
                }
            });
            return list;
        }

        public ZipOutputStream addToArchive(ZipOutputStream zipOutput, InputStream input, String entryName1) throws Exception {
            byte[] data = new byte[2048];
            ZipEntry entry = new ZipEntry(entryName1);
            zipOutput.putNextEntry(entry);
            if (input != null) {
                int count;
                while ((count = input.read(data, 0, 2048)) != -1) {
                    zipOutput.write(data, 0, count);
                }
            }
            zipOutput.closeEntry();
            return zipOutput;
        }

        public JarOutputStream addToArchive(JarOutputStream jarOutput, InputStream input, String entryName1) throws Exception {
            byte[] data = new byte[2048];
            JarEntry entry = new JarEntry(entryName1);
            jarOutput.putNextEntry(entry);
            if (input != null) {
                int count;
                while ((count = input.read(data, 0, 2048)) != -1) {
                    jarOutput.write(data, 0, count);
                }
            }
            jarOutput.closeEntry();
            return jarOutput;
        }

        @Override
        public void getZipOut(boolean containParent, ZipOutputStream zos) throws Exception {
            String path = this.file_.getAbsolutePath();
            FileInputStream bufInput = null;
            List<File> list = this.listFile(this.file_);
            if (this.file_.isDirectory()) {
                list.remove(this.file_);
            }
            if (list == null || list.size() < 1) {
                throw new Exception("nothing in the list");
            }
            for (File f : list) {
                String filePath = f.getAbsolutePath();
                if (filePath.startsWith(path)) {
                    filePath = containParent && this.file_.isDirectory() ? this.file_.getName() + File.separator + filePath.substring(path.length() + 1) : (this.file_.isDirectory() ? filePath.substring(path.length() + 1) : this.file_.getName());
                }
                if (f.isFile()) {
                    bufInput = new FileInputStream(f);
                } else {
                    filePath = filePath + "/";
                }
                this.addToArchive(zos, (InputStream)bufInput, filePath);
            }
        }
    }

    public static abstract class DataInstance {
        protected String entryName_;
        protected String typeZip_;

        public abstract InputStream getInputStream();

        public abstract void getJarOut(boolean var1, JarOutputStream var2) throws Exception;

        public abstract void getZipOut(boolean var1, ZipOutputStream var2) throws Exception;

        public String getEntryName() {
            return this.entryName_;
        }

        public void setType(String typeZip) {
            this.typeZip_ = typeZip;
        }

        public String getType() {
            return this.typeZip_;
        }
    }
}

