/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.threadpool.impl;

import java.util.ArrayList;

public class Queue {
    private ArrayList data = new ArrayList();
    private int maxQueueSize = Integer.MAX_VALUE;

    public synchronized void put(Object obj) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (obj == null) {
            throw new IllegalArgumentException("null");
        }
        while (this.data.size() >= this.maxQueueSize) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.data.add(obj);
        this.notify();
    }

    public synchronized boolean put(Object obj, long msecs) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (obj == null) {
            throw new IllegalArgumentException("null");
        }
        long startTime = System.currentTimeMillis();
        long waitTime = msecs;
        while (this.data.size() >= this.maxQueueSize) {
            waitTime = msecs - (System.currentTimeMillis() - startTime);
            if (waitTime <= 0L) {
                return false;
            }
            this.wait(waitTime);
        }
        this.data.add(obj);
        this.notify();
        return true;
    }

    public synchronized Object get() throws InterruptedException {
        while (this.data.size() == 0) {
            this.wait();
        }
        Object obj = this.data.remove(0);
        this.notify();
        return obj;
    }

    public synchronized Object get(long msecs) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long waitTime = msecs;
        if (this.data.size() > 0) {
            return this.data.remove(0);
        }
        do {
            if ((waitTime = msecs - (System.currentTimeMillis() - startTime)) <= 0L) {
                return null;
            }
            this.wait(waitTime);
        } while (this.data.size() <= 0);
        Object obj = this.data.remove(0);
        this.notify();
        return obj;
    }

    public void setMaxQueueSize(int newValue) {
        this.maxQueueSize = newValue;
    }
}

