/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class ConfiguratorTest
extends TestCase {
    ProtocolStack stack;
    static final String props = "UDP(mcast_addr=225.1.2.3):PING:FD:pbcast.NAKACK:UNICAST:FC";
    final String[] names = new String[]{"FC", "UNICAST", "NAKACK", "FD", "PING", "UDP"};
    final String[] below = new String[]{"FC", "UNICAST", "TRACE", "NAKACK", "FD", "PING", "UDP"};
    final String[] above = new String[]{"FC", "TRACE", "UNICAST", "NAKACK", "FD", "PING", "UDP"};

    public ConfiguratorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        JChannel mock_channel = new JChannel(){};
        this.stack = new ProtocolStack(mock_channel, props);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInsertion() throws Exception {
        Protocol p;
        String name;
        int i;
        this.stack.setup();
        Vector<Protocol> protocols = this.stack.getProtocols();
        ConfiguratorTest.assertNotNull(protocols);
        ConfiguratorTest.assertEquals((int)6, (int)protocols.size());
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            String name2 = this.names[i2];
            Protocol p2 = (Protocol)protocols.get(i2);
            ConfiguratorTest.assertEquals((String)name2, (String)p2.getName());
        }
        Protocol new_prot = (Protocol)Class.forName("org.jgroups.protocols.TRACE").newInstance();
        this.stack.insertProtocol(new_prot, 2, "UNICAST");
        protocols = this.stack.getProtocols();
        ConfiguratorTest.assertEquals((int)7, (int)protocols.size());
        for (int i3 = 0; i3 < this.below.length; ++i3) {
            String name3 = this.below[i3];
            Protocol p3 = (Protocol)protocols.get(i3);
            ConfiguratorTest.assertEquals((String)name3, (String)p3.getName());
        }
        Protocol prot = this.stack.removeProtocol("TRACE");
        ConfiguratorTest.assertNotNull((Object)prot);
        protocols = this.stack.getProtocols();
        ConfiguratorTest.assertEquals((int)6, (int)protocols.size());
        for (i = 0; i < this.names.length; ++i) {
            name = this.names[i];
            p = (Protocol)protocols.get(i);
            ConfiguratorTest.assertEquals((String)name, (String)p.getName());
        }
        new_prot = (Protocol)Class.forName("org.jgroups.protocols.TRACE").newInstance();
        this.stack.insertProtocol(new_prot, 1, "UNICAST");
        protocols = this.stack.getProtocols();
        ConfiguratorTest.assertEquals((int)7, (int)protocols.size());
        for (i = 0; i < this.above.length; ++i) {
            name = this.above[i];
            p = (Protocol)protocols.get(i);
            ConfiguratorTest.assertEquals((String)name, (String)p.getName());
        }
    }

    public void testParsing() throws Exception {
        String config = "UDP(mcast_addr=ff18:eb72:479f::2:3;oob_thread_pool.max_threads=4;oob_thread_pool.keep_alive_time=5000;max_bundle_size=64000;mcast_send_buf_size=640000;oob_thread_pool.queue_max_size=10;mcast_recv_buf_size=25000000;use_concurrent_stack=true;tos=8;mcast_port=45522;loopback=true;thread_pool.min_threads=2;oob_thread_pool.rejection_policy=Run;thread_pool.max_threads=8;enable_diagnostics=true;thread_naming_pattern=cl;ucast_send_buf_size=640000;ucast_recv_buf_size=20000000;thread_pool.enabled=true;use_incoming_packet_handler=true;oob_thread_pool.enabled=true;ip_ttl=2;enable_bundling=true;thread_pool.rejection_policy=Run;discard_incompatible_packets=true;thread_pool.keep_alive_time=5000;thread_pool.queue_enabled=false;mcast_addr=228.10.10.15;max_bundle_timeout=30;oob_thread_pool.queue_enabled=false;oob_thread_pool.min_threads=2;thread_pool.queue_max_size=100):PING(num_initial_members=3;timeout=2000):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:FD(max_tries=3;timeout=2000):VERIFY_SUSPECT(timeout=1500):BARRIER:pbcast.NAKACK(gc_lag=0;use_mcast_xmit=false;retransmit_timeout=300,600,1200,2400,4800;discard_delivered_msgs=true;max_xmit_size=60000):UNICAST(loopback=false;timeout=300,600,1200,2400,3600):pbcast.STABLE(desired_avg_gossip=50000;max_bytes=1000000;stability_delay=1000):VIEW_SYNC(avg_send_interval=60000):pbcast.GMS(print_local_addr=true;view_bundling=true;join_timeout=3000;join_retry_timeout=2000;shun=false):FC(max_block_time=10000;max_credits=5000000;min_threshold=0.25):FRAG2(frag_size=60000):pbcast.STREAMING_STATE_TRANSFER(use_reading_thread=true)";
        Vector<Configurator.ProtocolConfiguration> ret = Configurator.parseConfigurations(config);
        System.out.println("config:\n" + ret);
        ConfiguratorTest.assertEquals((int)15, (int)ret.size());
        config = "UDP(mcast_addr=ff18:eb72:479f::2:3;mcast_port=2453):pbcast.FD:FRAG(frag_size=2292):FD_SIMPLE(s=22;d=33):MERGE2(a=22)";
        ret = Configurator.parseConfigurations(config);
        System.out.println("config:\n" + ret);
        ConfiguratorTest.assertEquals((int)5, (int)ret.size());
        config = "com.mycomp.Class:B:pbcast.C:H(a=b;c=d;e=f)";
        ret = Configurator.parseConfigurations(config);
        System.out.println("config:\n" + ret);
        ConfiguratorTest.assertEquals((int)4, (int)ret.size());
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConfiguratorTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

