/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;
import org.exoplatform.services.organization.auth.JAASGroup;
import org.exoplatform.services.organization.auth.RolePrincipal;
import org.exoplatform.services.organization.auth.UserPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JonasAuthenticationListener
extends Listener<AuthenticationService, Identity> {
    private String userRoleParentGroup = null;

    public JonasAuthenticationListener(InitParams params) {
        ValueParam param;
        if (params != null && (param = params.getValueParam("user.role.parent.group")) != null && param.getValue().length() > 0) {
            this.userRoleParentGroup = param.getValue();
        }
    }

    public void onEvent(Event<AuthenticationService, Identity> event) throws Exception {
        OrganizationService service = ((AuthenticationService)event.getSource()).getOrganizationService();
        Identity identity = (Identity)event.getData();
        Subject subject = identity.getSubject();
        String username = identity.getUsername();
        subject.getPrincipals().add(new UserPrincipal(username));
        Collection groups = service.getGroupHandler().findGroupsOfUser(username);
        JAASGroup roleGroup = new JAASGroup("Roles");
        for (Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            if (this.userRoleParentGroup != null && splittedGroupName[0].equals(this.userRoleParentGroup) && splittedGroupName.length > 1) {
                roleGroup.addMember(new RolePrincipal(splittedGroupName[splittedGroupName.length - 1]));
                continue;
            }
            roleGroup.addMember(new RolePrincipal(splittedGroupName[0]));
        }
        subject.getPrincipals().add((Principal)((Object)roleGroup));
    }
}

