/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.frameworks.jcr.SingleRepositorySessionFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;

public class SimpleSessionFactoryInitializedFilter
implements Filter {
    private static Log log = ExoLogger.getLogger((String)"jcr.SimpleSessionFactoryInitializedFilter");
    private ServletContext servletContext;
    private String userId = null;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpRequest.getSession();
        String portalName = this.servletContext.getServletContextName();
        ExoContainer container = ExoContainerContext.getContainerByName((String)portalName);
        if (container == null) {
            container = ExoContainerContext.getTopContainer();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        AuthenticationService authenticationService = (AuthenticationService)container.getComponentInstanceOfType(AuthenticationService.class);
        if (httpRequest.getRemoteUser() != null && authenticationService.getCurrentIdentity() == null) {
            log.warn((Object)("Cannot find the identity for user " + httpRequest.getRemoteUser() + ", trying to create the new one"));
            Identity identity = null;
            try {
                identity = authenticationService.getIdentityBySessionId(httpRequest.getRemoteUser());
            }
            catch (Exception e) {
                log.error((Object)"Can't find identity by sessionID ", (Throwable)e);
            }
            authenticationService.setCurrentIdentity(identity);
        }
        try {
            if (httpRequest.getSession().getAttribute("org.exoplatform.frameworks.web.sessionFactory") == null || this.userChanged(httpRequest, authenticationService)) {
                ManageableRepository rep;
                String repositoryName = this.servletContext.getInitParameter("org.exoplatform.frameworks.web.repositoryJNDIName");
                if (repositoryName != null) {
                    try {
                        InitialContext ctx = new InitialContext();
                        rep = (ManageableRepository)ctx.lookup(repositoryName);
                        log.info((Object)("Repository found in the JNDI context " + rep + " InitialContextFactory: " + System.getProperty("java.naming.factory.initial")));
                        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                        repositoryService.setCurrentRepositoryName(repositoryName);
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                        throw new ServletException((Throwable)e);
                    }
                    catch (RepositoryConfigurationException e) {
                        e.printStackTrace();
                        throw new ServletException((Throwable)e);
                    }
                }
                log.info((Object)"No Repository object found in the JNDI context. Try to get from container");
                RepositoryService service = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                try {
                    rep = service.getDefaultRepository();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
                httpRequest.getSession().setAttribute("org.exoplatform.frameworks.web.sessionFactory", (Object)new SingleRepositorySessionFactory(rep));
            }
            chain.doFilter(request, response);
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }

    public void destroy() {
    }

    private boolean userChanged(HttpServletRequest httpRequest, AuthenticationService authenticationService) {
        String newUser = httpRequest.getRemoteUser();
        boolean res = true;
        if (this.userId == null) {
            if (newUser == null) {
                res = false;
            }
        } else {
            boolean bl = res = !this.userId.equals(newUser);
        }
        if (res) {
            if (newUser != null) {
                Identity identity = null;
                try {
                    identity = authenticationService.getIdentityBySessionId(newUser);
                }
                catch (Exception e) {
                    log.error((Object)"Can't find identity by sessionID ", (Throwable)e);
                }
                authenticationService.setCurrentIdentity(identity);
            }
            this.userId = newUser;
        }
        return res;
    }
}

