/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.lifecycle;

import groovy.text.Template;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.javascript.JavaScriptEngine;
import org.exoplatform.javascript.JavaScriptEngineService;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Decorator;
import org.exoplatform.webui.core.lifecycle.HtmlValidator;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.core.lifecycle.WebuiTemplateContext;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lifecycle {
    private static boolean DEVELOPING = false;
    protected static Log log = ExoLogger.getLogger((String)"portal:Lifecycle");
    private Decorator decorator_ = new Decorator();

    public void init(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
    }

    public void processDecode(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
    }

    public void processAction(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        String action = context.getRequestParameter(context.getActionParameterName());
        if (action == null) {
            return;
        }
        Event<UIComponent> event = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void processRender(UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        String template = uicomponent.getTemplate();
        if (template.endsWith(".jstmpl")) {
            ResourceResolver resolver = uicomponent.getTemplateResourceResolver(context, template);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.renderJSTemplate(template, variables, resolver, uicomponent, context);
        } else {
            ResourceResolver resolver = uicomponent.getTemplateResourceResolver(context, template);
            WebuiBindingContext bcontext = new WebuiBindingContext(resolver, context.getWriter(), uicomponent, context);
            bcontext.put("uicomponent", uicomponent);
            bcontext.put(uicomponent.getUIComponentName(), uicomponent);
            this.renderTemplate(template, bcontext);
        }
    }

    public void destroy(UIComponent uicomponent) throws Exception {
    }

    protected void renderTemplate(String template, WebuiBindingContext bcontext) throws Exception {
        bcontext.put("decorator", this.decorator_);
        WebuiRequestContext context = bcontext.getRequestContext();
        ExoContainer pcontainer = context.getApplication().getApplicationServiceContainer();
        TemplateService service = (TemplateService)pcontainer.getComponentInstanceOfType(TemplateService.class);
        ResourceResolver resolver = bcontext.getResourceResolver();
        if (DEVELOPING) {
            long lastAccess;
            WebuiRequestContext rootContext = (WebuiRequestContext)context.getParentAppRequestContext();
            if (rootContext == null) {
                rootContext = context;
            }
            if (resolver.isModified(template, lastAccess = rootContext.getUIApplication().getLastAccessApplication())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalidate the template: " + template));
                }
                service.invalidateTemplate(template, resolver);
            }
        }
        try {
            Template groovyTemplate = service.getTemplate(template, resolver);
            if (bcontext.getWriter() instanceof HtmlValidator) {
                HtmlValidator validator = (HtmlValidator)bcontext.getWriter();
                validator.startComponent();
            }
            service.merge(groovyTemplate, (BindingContext)bcontext);
            if (bcontext.getWriter() instanceof HtmlValidator) {
                HtmlValidator validator = (HtmlValidator)bcontext.getWriter();
                validator.endComponent();
            }
        }
        catch (Exception e) {
            log.error((Object)("template : " + template), (Throwable)e);
        }
    }

    protected void renderJSTemplate(String template, Map<String, Object> variables, ResourceResolver resolver, UIComponent uicomponent, WebuiRequestContext context) throws Exception {
        ExoContainer pcontainer = context.getApplication().getApplicationServiceContainer();
        JavaScriptEngineService service = (JavaScriptEngineService)pcontainer.getComponentInstanceOfType(JavaScriptEngineService.class);
        WebuiTemplateContext webuiTmplContext = new WebuiTemplateContext((JavaScriptEngine)service, resolver, uicomponent, context);
        webuiTmplContext.setVariables(variables);
        webuiTmplContext.setVariable("decorator", this.decorator_);
        webuiTmplContext.setVariable("uicomponent", uicomponent);
        webuiTmplContext.setVariable(uicomponent.getUIComponentName(), uicomponent);
        webuiTmplContext.render(template);
    }

    static {
        DEVELOPING = "true".equals(System.getProperty("exo.product.developing"));
    }
}

