/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.portal.application.UserWidgetStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class UserWidgetStorageImpl
implements UserWidgetStorage {
    public static final String WIDGETS_REGETSTRY_NODE = "widgets";
    public static final String DATA = "data";
    public static final String WIDGET_NODE_TYPE = "exo:widget";
    private NodeHierarchyCreator nodeCreator;

    public UserWidgetStorageImpl(NodeHierarchyCreator creator) throws Exception {
        this.nodeCreator = creator;
    }

    private Node createWidgetInstanceNode(SessionProvider sessionProvider, String userName, String widgetType, String instanceId) throws Exception {
        Node userApplicationsNode = this.nodeCreator.getUserApplicationNode(sessionProvider, userName);
        Node widgetsApp = this.getNode(userApplicationsNode, WIDGETS_REGETSTRY_NODE, null);
        Node widgetsTypeNode = this.getNode(widgetsApp, widgetType, null);
        Node node = this.getNode(widgetsTypeNode, instanceId, WIDGET_NODE_TYPE);
        userApplicationsNode.save();
        return node;
    }

    public void save(String userName, String widgetType, String instantId, Object data) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node widgetNode = this.createWidgetInstanceNode(sessionProvider, userName, widgetType, instantId);
        InputStream inputStream = data instanceof byte[] ? new ByteArrayInputStream((byte[])data) : (data instanceof InputStream ? (InputStream)data : new ByteArrayInputStream(data.toString().getBytes()));
        widgetNode.setProperty(DATA, inputStream);
        widgetNode.save();
        sessionProvider.close();
    }

    public Object get(String userName, String widgetType, String instantId) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node widgetNode = this.getWidgetNode(sessionProvider, userName, widgetType, instantId);
        if (widgetNode == null) {
            sessionProvider.close();
            return null;
        }
        byte[] bytes = IOUtil.getStreamContentAsBytes((InputStream)widgetNode.getProperty(DATA).getStream());
        sessionProvider.close();
        return bytes;
    }

    public void delete(String userName, String widgetType, String instantId) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node widgetNode = this.getWidgetNode(sessionProvider, userName, widgetType, instantId);
        if (widgetNode == null) {
            sessionProvider.close();
            return;
        }
        Node parentNode = widgetNode.getParent();
        widgetNode.remove();
        parentNode.save();
        sessionProvider.close();
    }

    private Node getNode(Node parent, String name, String nodeType) throws Exception {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        Node node = null;
        node = nodeType == null ? parent.addNode(name) : parent.addNode(name, nodeType);
        parent.save();
        return node;
    }

    private Node getWidgetNode(SessionProvider sessionProvider, String userName, String widgetType, String instantId) throws Exception {
        String instancePath;
        Node userAppsNode = this.nodeCreator.getUserApplicationNode(sessionProvider, userName);
        if (userAppsNode.hasNode(instancePath = "widgets/" + widgetType + "/" + instantId)) {
            return userAppsNode.getNode(instancePath);
        }
        return null;
    }
}

