/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Widgets;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewPortalConfigListener
extends BaseComponentPlugin {
    private ConfigurationManager cmanager_;
    private DataStorage pdcService_;
    private List<?> configs;
    private String defaultPortal;

    public NewPortalConfigListener(DataStorage pdcService, ConfigurationManager cmanager, InitParams params) throws Exception {
        this.cmanager_ = cmanager;
        this.pdcService_ = pdcService;
        String checkPortal = "site";
        ValueParam valueParam = params.getValueParam("default.portal");
        if (valueParam != null) {
            checkPortal = valueParam.getValue();
        }
        if (checkPortal == null || checkPortal.trim().length() == 0) {
            checkPortal = "site";
        }
        this.configs = params.getObjectParamValues(NewPortalConfig.class);
        if (this.isInitedDB(checkPortal)) {
            return;
        }
        for (Object ele : this.configs) {
            NewPortalConfig portalConfig = (NewPortalConfig)ele;
            if (portalConfig.getOwnerType().equals("user")) {
                this.initUserTypeDB(portalConfig);
            } else if (portalConfig.getOwnerType().equals("group")) {
                this.initGroupTypeDB(portalConfig);
            } else {
                this.initPortalTypeDB(portalConfig);
            }
            portalConfig.getPredefinedOwner().clear();
        }
    }

    NewPortalConfig getPortalConfig(String ownerType) {
        for (Object object : this.configs) {
            NewPortalConfig portalConfig = (NewPortalConfig)object;
            if (!portalConfig.getOwnerType().equals(ownerType)) continue;
            return portalConfig;
        }
        return null;
    }

    private boolean isInitedDB(String user) throws Exception {
        PortalConfig pconfig = this.pdcService_.getPortalConfig(user);
        return pconfig != null;
    }

    public void initUserTypeDB(NewPortalConfig config) throws Exception {
        HashSet<String> owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createWidgets(config, owner);
        }
    }

    public void initGroupTypeDB(NewPortalConfig config) throws Exception {
        HashSet<String> owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createPortletPreferences(config, owner);
        }
    }

    public void initPortalTypeDB(NewPortalConfig config) throws Exception {
        HashSet<String> owners = config.getPredefinedOwner();
        for (String owner : owners) {
            this.createPortalConfig(config, owner);
            this.createPage(config, owner);
            this.createPageNavigation(config, owner);
            this.createPortletPreferences(config, owner);
        }
    }

    private void createPortalConfig(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        xml = config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1 ? this.getDefaultConfig(config, owner, "portal") : this.getTemplateConfig(config, owner, "portal");
        PortalConfig pconfig = this.fromXML(xml, PortalConfig.class);
        this.pdcService_.create(pconfig);
    }

    private void createPage(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        xml = config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1 ? this.getDefaultConfig(config, owner, "pages") : this.getTemplateConfig(config, owner, "pages");
        Page.PageSet pageSet = this.fromXML(xml, Page.PageSet.class);
        ArrayList<Page> list = pageSet.getPages();
        for (Page page : list) {
            this.pdcService_.create(page);
        }
    }

    private void createPageNavigation(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        xml = config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1 ? this.getDefaultConfig(config, owner, "navigation") : this.getTemplateConfig(config, owner, "navigation");
        PageNavigation navigation = this.fromXML(xml, PageNavigation.class);
        this.pdcService_.create(navigation);
    }

    private void createWidgets(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        xml = config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1 ? this.getDefaultConfig(config, owner, "widgets") : this.getTemplateConfig(config, owner, "widgets");
        Widgets widgets = this.fromXML(xml, Widgets.class);
        this.pdcService_.create(widgets);
    }

    private void createPortletPreferences(NewPortalConfig config, String owner) throws Exception {
        String xml = null;
        xml = config.getTemplateOwner() == null || config.getTemplateOwner().trim().length() < 1 ? this.getDefaultConfig(config, owner, "portlet-preferences") : this.getTemplateConfig(config, owner, "portlet-preferences");
        PortletPreferences.PortletPreferencesSet portletSet = this.fromXML(xml, PortletPreferences.PortletPreferencesSet.class);
        ArrayList<PortletPreferences> list = portletSet.getPortlets();
        for (PortletPreferences portlet : list) {
            this.pdcService_.save(portlet);
        }
    }

    private String getDefaultConfig(NewPortalConfig portalConfig, String owner, String dataType) throws Exception {
        String ownerType = portalConfig.getOwnerType();
        String path = "/" + ownerType + "/" + owner + "/" + dataType + ".xml";
        String location = portalConfig.getTemplateLocation();
        return IOUtil.getStreamContentAsString((InputStream)this.cmanager_.getInputStream(location + path));
    }

    private String getTemplateConfig(NewPortalConfig portalConfig, String owner, String dataType) throws Exception {
        String ownerType = portalConfig.getOwnerType();
        String templateLoc = portalConfig.getTemplateLocation();
        String path = "/" + ownerType + "/template/" + portalConfig.getTemplateOwner() + "/" + dataType + ".xml";
        InputStream is = this.cmanager_.getInputStream(templateLoc + path);
        String template = IOUtil.getStreamContentAsString((InputStream)is);
        return StringUtils.replace((String)template, (String)"@owner@", (String)owner);
    }

    private <T> T fromXML(String xml, Class<T> clazz) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        IBindingFactory bfact = BindingDirectory.getFactory(clazz);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return clazz.cast(uctx.unmarshalDocument((InputStream)is, "UTF-8"));
    }

    String getDefaultPortal() {
        return this.defaultPortal;
    }
}

