/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceInitializer {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceInitializer");
    private String systemWorkspaceName;
    private String workspaceName;
    private DataManager dataManager;
    private String accessControlType;
    private NamespaceDataPersister nsPersister;
    private ExtendedNodeTypeManager ntRegistry;
    private NodeTypeDataPersister ntPersister;
    private SearchIndex searchIndex;
    private String autoInitPermissions;

    public WorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceDataPersister nsPersister, ExtendedNodeTypeManager ntRegistry, NodeTypeDataPersister ntPersister) {
        this.workspaceName = config.getName();
        this.autoInitPermissions = config.getAutoInitPermissions();
        this.systemWorkspaceName = repConfig.getSystemWorkspaceName();
        this.dataManager = dataManager;
        this.nsPersister = nsPersister;
        this.ntRegistry = ntRegistry;
        this.ntPersister = ntPersister;
        this.accessControlType = repConfig.getAccessControl();
    }

    public WorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceDataPersister nsPersister, ExtendedNodeTypeManager ntRegistry, NodeTypeDataPersister ntPersister, SearchIndex searchIndex) {
        this.workspaceName = config.getName();
        this.autoInitPermissions = config.getAutoInitPermissions();
        this.systemWorkspaceName = repConfig.getSystemWorkspaceName();
        this.dataManager = dataManager;
        this.nsPersister = nsPersister;
        this.ntRegistry = ntRegistry;
        this.ntPersister = ntPersister;
        this.accessControlType = repConfig.getAccessControl();
        this.searchIndex = searchIndex;
    }

    public NodeData initWorkspace(InternalQName rootNodeType) throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        NodeData root = this.initRootNode(rootNodeType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root node for " + this.workspaceName + " initialized. NodeType: " + (Object)((Object)rootNodeType) + " system workspace: " + this.systemWorkspaceName));
        }
        if (this.workspaceName.equals(this.systemWorkspaceName)) {
            NodeData nodeData = this.initJcrSystemNode(root);
        }
        return root;
    }

    public void startWorkspace() throws RepositoryException {
        this.initSearchIndex();
    }

    private void initSearchIndex() throws RepositoryException {
        if (this.searchIndex != null) {
            try {
                this.searchIndex.init();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public boolean isWorkspaceInitialized() {
        try {
            return this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000") != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private NodeData initRootNode(InternalQName rootNodeType) throws RepositoryException {
        boolean addACL;
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        TransientNodeData rootNode = new TransientNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, rootNodeType, new InternalQName[0], 0, null, new AccessControlList());
        changesLog.add(new ItemState(rootNode, 1, false, null));
        TransientPropertyData primaryType = new TransientPropertyData(QPath.makeChildPath(rootNode.getQPath(), Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, rootNode.getIdentifier(), false);
        primaryType.setValue(new TransientValueData(rootNodeType));
        changesLog.add(new ItemState(primaryType, 1, false, null));
        boolean bl = addACL = !this.accessControlType.equals("disable");
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            if (this.autoInitPermissions != null) {
                acl.removePermissions(SystemIdentity.ANY);
                acl.addPermissions(this.autoInitPermissions);
            }
            rootNode.setACL(acl);
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            rootNode.setMixinTypeNames(mixins);
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(rootNode, 16, false, null));
        }
        this.dataManager.save(new TransactionChangesLog(changesLog));
        return rootNode;
    }

    private NodeData initJcrSystemNode(NodeData root) throws RepositoryException {
        boolean addACL;
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        TransientNodeData jcrSystem = TransientNodeData.createNodeData(root, Constants.JCR_SYSTEM, Constants.NT_UNSTRUCTURED, "00exo0jcr0system0uuid00000000000");
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(jcrSystem, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(jcrSystem.getPrimaryTypeName()));
        changesLog.add(ItemState.createAddedState(jcrSystem)).add(ItemState.createAddedState(primaryType));
        boolean bl = addACL = !this.accessControlType.equals("disable");
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            jcrSystem.setMixinTypeNames(mixins);
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(jcrSystem, 16, false, null));
        }
        TransientNodeData versionStorageNodeData = TransientNodeData.createNodeData((NodeData)jcrSystem, Constants.JCR_VERSIONSTORAGE, Constants.EXO_VERSIONSTORAGE, "00exo0jcr0version0storage0uuid00");
        TransientPropertyData vsPrimaryType = TransientPropertyData.createPropertyData(versionStorageNodeData, Constants.JCR_PRIMARYTYPE, 7, false);
        vsPrimaryType.setValue(new TransientValueData(versionStorageNodeData.getPrimaryTypeName()));
        changesLog.add(ItemState.createAddedState(versionStorageNodeData)).add(ItemState.createAddedState(vsPrimaryType));
        this.dataManager.save(new TransactionChangesLog(changesLog));
        this.nsPersister.initStorage(jcrSystem, addACL, NamespaceRegistryImpl.DEF_NAMESPACES);
        this.ntPersister.initNodetypesRoot(jcrSystem, addACL);
        this.ntPersister.initStorage(((EntityCollection)this.ntRegistry.getAllNodeTypes()).getList());
        return jcrSystem;
    }
}

