/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.security.auth.Subject;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.access.BaseAuthenticationPolicy;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.security.impl.CredentialsImpl;

public class PortalAuthenticationPolicy
extends BaseAuthenticationPolicy {
    private static final Credentials SYSTEM_CRED = new CredentialsImpl(SystemIdentity.ANONIM, new char[0]);
    private AuthenticationService authService_;

    public PortalAuthenticationPolicy(RepositoryEntry config, AuthenticationService service) {
        super(config, null);
        this.authService_ = service;
    }

    public Credentials authenticate() throws LoginException {
        Credentials cred = null;
        Subject subj = this.authService_.getCurrentIdentity().getSubject();
        if (subj == null) {
            throw new LoginException("PortalAuthenticationPolicy: current subject is not found in security service");
        }
        for (Object tmp : subj.getPublicCredentials()) {
            if (!(tmp instanceof Credentials)) continue;
            cred = (Credentials)tmp;
            if (log.isDebugEnabled()) {
                log.debug((Object)("PortalAuthenticationPolicy.authenticate() found credentials " + cred + " in SecurityService"));
            }
            return cred;
        }
        return SYSTEM_CRED;
    }
}

