/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryHandler;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.TextFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheck;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIndexer;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldSortComparator;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndex
extends AbstractQueryHandler
implements ItemsPersistenceListener {
    private static Log log = ExoLogger.getLogger((String)"jcr.SearchIndex");
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = 100000;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    private MultiIndex index;
    private final Analyzer analyzer;
    private List textFilters;
    private String path;
    private int minMergeDocs = 100;
    private int volatileIdleTime = 3;
    private int maxMergeDocs = 100000;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = true;
    private boolean forceConsistencyCheck = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private DocumentReaderService documentReaderService = null;
    private WorkspacePersistentDataManager dataManager;
    private final LocationFactory sysLocationFactory;
    private final String rootIdentifier;
    private boolean closed = false;
    private final Object onSaveMonitor = new Object();

    public SearchIndex(WorkspaceEntry config, DocumentReaderService ds, WorkspacePersistentDataManager dataManager, LocationFactory sysLocationFactory) throws RepositoryConfigurationException, IOException {
        this.analyzer = new StandardAnalyzer();
        String indexDir = config.getQueryHandler().getParameterValue("indexDir");
        indexDir = indexDir.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
        this.path = indexDir + "/" + config.getName();
        this.documentReaderService = ds;
        this.dataManager = dataManager;
        this.sysLocationFactory = sysLocationFactory;
        this.rootIdentifier = "00exo0jcr0root0uuid0000000000000";
    }

    @Override
    public void init() throws IOException {
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        this.index = new MultiIndex(new File(this.path), this, this.dataManager, this.rootIdentifier);
        if (this.index.getRedoLogApplied() || this.forceConsistencyCheck) {
            log.info((Object)"Running consistency check...");
            try {
                ConsistencyCheck check = ConsistencyCheck.run(this.index, this.dataManager);
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info((Object)"No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info((Object)err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to run consistency check on index: " + e));
            }
        }
        this.dataManager.addItemPersistenceListener(this);
    }

    @Override
    public void addNode(NodeImpl node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    @Override
    public void deleteNode(String identifier) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    @Override
    public void updateNodes(Iterator remove, Iterator add) throws RepositoryException, IOException {
        this.checkOpen();
        this.index.update((Iterator)new AbstractIteratorDecorator(remove){

            public Object next() {
                String identifier = (String)super.next();
                return new Term(FieldNames.UUID, identifier);
            }
        }, (Iterator)new AbstractIteratorDecorator(add){

            public Object next() {
                NodeData state = (NodeData)super.next();
                try {
                    if (state != null) {
                        return new NodeIndexer(state, SearchIndex.this.sysLocationFactory, SearchIndex.this.documentReaderService, SearchIndex.this.dataManager).createDoc();
                    }
                    return null;
                }
                catch (RepositoryException e) {
                    log.error((Object)("Exception while creating document for node: " + state.getQPath().getAsString() + ": " + e.toString()), (Throwable)e);
                    return null;
                }
            }
        });
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionImpl session, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, this, statement, language);
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.index.close();
            this.closed = true;
            log.info((Object)"Search index closed.");
        } else {
            log.warn((Object)"Search index already closed.");
        }
    }

    QueryHits executeQuery(Query query, InternalQName[] orderProps, boolean[] orderSpecs) throws IOException {
        Hits hits;
        this.checkOpen();
        SortField[] sortFields = this.createSortFields(orderProps, orderSpecs);
        IndexReader reader = this.index.getIndexReader();
        IndexSearcher searcher = new IndexSearcher(reader);
        if (sortFields.length > 0) {
            hits = searcher.search(query, new Sort(sortFields));
            searcher.close();
        } else {
            hits = searcher.search(query);
            searcher.close();
        }
        return new QueryHits(hits, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        LinkedHashSet<String> removedNodes = new LinkedHashSet<String>();
        LinkedHashMap<String, NodeData> addedNodes = new LinkedHashMap<String, NodeData>();
        ThreadLocal<ItemState> currentItemState = new ThreadLocal<ItemState>();
        Object object = this.onSaveMonitor;
        synchronized (object) {
            List<ItemState> itemStates = changesLog.getAllStates();
            for (ItemState itemState : itemStates) {
                currentItemState.set(itemState);
                if (itemState.isNode()) {
                    if (itemState.isAdded() || itemState.isRenamed()) {
                        addedNodes.put(itemState.getData().getIdentifier(), (NodeData)itemState.getData());
                        continue;
                    }
                    if (itemState.isDeleted()) {
                        removedNodes.add(itemState.getData().getIdentifier());
                        continue;
                    }
                    if (!itemState.isMixinChanged() || addedNodes.containsKey(itemState.getData().getIdentifier())) continue;
                    removedNodes.add(itemState.getData().getIdentifier());
                    addedNodes.put(itemState.getData().getIdentifier(), (NodeData)itemState.getData());
                    continue;
                }
                String parentIdentifier = itemState.getData().getParentIdentifier();
                if (this.getItemState(parentIdentifier, itemStates) != null) continue;
                removedNodes.add(parentIdentifier);
                try {
                    NodeData parentData = (NodeData)this.dataManager.getItemData(parentIdentifier);
                    addedNodes.put(parentData.getIdentifier(), parentData);
                }
                catch (RepositoryException e) {
                    log.error((Object)("Error indexing node (addNode: " + parentIdentifier + ")."), (Throwable)e);
                }
            }
            this.onSaveMonitor.notifyAll();
        }
        try {
            this.updateNodes(removedNodes.iterator(), addedNodes.values().iterator());
        }
        catch (RepositoryException e) {
            log.error((Object)("Error indexing node. " + (currentItemState.get() != null ? ((ItemState)currentItemState.get()).getData().getQPath().getAsString() : "<null>")), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error indexing node. " + (currentItemState.get() != null ? ((ItemState)currentItemState.get()).getData().getQPath().getAsString() : "<null>")), (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)("Error indexing node. " + (currentItemState.get() != null ? ((ItemState)currentItemState.get()).getData().getQPath().getAsString() : "<null>")), e);
        }
    }

    private ItemState getItemState(String identifier, List<ItemState> itemStates) {
        for (ItemState istate : itemStates) {
            if (!istate.getData().getIdentifier().equals(identifier)) continue;
            return istate;
        }
        return null;
    }

    protected SortField[] createSortFields(InternalQName[] orderProps, boolean[] orderSpecs) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            String prop = null;
            if ("jcr:score".equals((Object)orderProps[i])) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            try {
                prop = this.sysLocationFactory.createJCRName(orderProps[i]).getAsString();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            sortFields.add(new SortField(prop, (SortComparatorSource)SharedFieldSortComparator.PROPERTIES, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    protected Document createDocument(NodeData node) throws RepositoryException {
        return node != null ? new NodeIndexer(node, this.sysLocationFactory, this.documentReaderService, this.dataManager).createDoc() : null;
    }

    protected MultiIndex getIndex() {
        return this.index;
    }

    public void setTextFilterClasses(String filterClasses) {
        ArrayList<TextFilter> filters = new ArrayList<TextFilter>();
        StringTokenizer tokenizer = new StringTokenizer(filterClasses, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                Class<?> filterClass = Class.forName(className);
                TextFilter filter = (TextFilter)filterClass.newInstance();
                filters.add(filter);
            }
            catch (Exception e) {
                log.warn((Object)("Invalid TextFilter class: " + className), (Throwable)e);
            }
            catch (LinkageError e) {
                log.warn((Object)("Missing dependency for text filter: " + className));
                log.warn((Object)e.toString());
            }
        }
        this.textFilters = Collections.unmodifiableList(filters);
    }

    public String getTextFilterClasses() {
        StringBuffer names = new StringBuffer();
        String delim = "";
        Iterator it = this.textFilters.iterator();
        while (it.hasNext()) {
            names.append(delim);
            names.append(it.next().getClass().getName());
            delim = ",";
        }
        return names.toString();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.index.getIndexReader();
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    public LocationFactory getSysLocationFactory() {
        return this.sysLocationFactory;
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver {
        private CachingMultiReader[] subReaders;
        private int[] starts;

        public CombinedIndexReader(CachingMultiReader[] indexReaders) throws IOException {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        public int getParent(int n) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumber((IndexReader)this);
        }

        private int readerIndex(int n) {
            int lo = 0;
            int hi = this.subReaders.length - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }
    }
}

