/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.ProcessEndpoints;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;

/**
 * @author Loic Albertin
 */
@RemoteServiceRelativePath("WSConsoleServices")
public interface WSConsoleServices extends RemoteService {
  /**
   * Utility/Convenience class.
   * Use WSConsoleServices.App.getInstance() to access static instance of WSConsoleServicesAsync
   */
  public static class App {
    private static final WSConsoleServicesAsync ourInstance = (WSConsoleServicesAsync) GWT.create(WSConsoleServices.class);

    public static WSConsoleServicesAsync getInstance() {
      return ourInstance;
    }
  }

  /**
   * Retrieves a {@link org.ow2.orchestra.console.ws.client.model.ProcessEndpoints} for a given process id
   *
   * @param processId The process id
   * @return The retrieved {@link org.ow2.orchestra.console.ws.client.model.ProcessEndpoints}
   */
  ProcessEndpoints getProcessEndpoints(String processId) throws OrchestraGwtException;

  /**
   * Generates a sample request for an {@link org.ow2.orchestra.console.ws.client.model.ActivityEndpoint}
   *
   * @param activityEndpoint The {@link org.ow2.orchestra.console.ws.client.model.ActivityEndpoint} for which a request should be generated
   * @return The generated request as String
   */
  SoapRequest generateRequest(ActivityEndpoint activityEndpoint) throws OrchestraGwtException;

  /**
   * Send a request on a given {@link ActivityEndpoint}
   *
   * @param request       The request to send
   * @return The response in case of request/response service
   */
  String sendRequest(SoapRequest request) throws OrchestraGwtException;
}
