/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.ProcessEndpoints;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;

/**
 * @author Loic Albertin
 */
public interface WSConsoleServicesAsync {
  /**
   * Retrieves a ProcessEndpoints for a given process id
   *
   * @param processId The process id
   * @param async     Callback allowing to retrieve the ProcessEndpoints
   */
  void getProcessEndpoints(String processId, AsyncCallback<ProcessEndpoints> async);

  /**
   * Generates a sample request for an {@link org.ow2.orchestra.console.ws.client.model.ActivityEndpoint}
   *
   * @param activityEndpoint The {@link org.ow2.orchestra.console.ws.client.model.ActivityEndpoint} for which a request should be generated
   * @param async         Callback allowing to retrieve the generated request as String
   */
  void generateRequest(ActivityEndpoint activityEndpoint, AsyncCallback<SoapRequest> async);

  /**
   * Send a request on a given {@link ActivityEndpoint}
   *
   * @param request       The request to send
   * @param async         Callback allowing to retrieve the response in case of request/response service
   */
  void sendRequest(SoapRequest request, AsyncCallback<String> async);
}
