/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.events;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;

/**
 * @author Loic Albertin
 */
public class ExploreProcessEndpointsEvent extends GwtEvent<ExploreProcessEndpointsEvent.ExploreProcessEndpointsEventHandler> {

  public static interface ExploreProcessEndpointsEventHandler extends EventHandler {
    void onExploreProcessEndpoints(ExploreProcessEndpointsEvent event);
  }

  public static Type<ExploreProcessEndpointsEventHandler> TYPE = new Type<ExploreProcessEndpointsEventHandler>();

  private String wsdlUrl;

  public ExploreProcessEndpointsEvent(String wsdlUrl) {
    this.wsdlUrl = wsdlUrl;
  }

  @Override
  public Type<ExploreProcessEndpointsEventHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ExploreProcessEndpointsEventHandler exploreProcessEndpointsEventHandler) {
    exploreProcessEndpointsEventHandler.onExploreProcessEndpoints(this);
  }

  public String getWsdlUrl() {
    return wsdlUrl;
  }
}
