/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.ow2.orchestra.common.gwt.utils.client.model.GwtQName;

/**
 * @author Loic Albertin
 */
public class ActivityEndpoint implements IsSerializable {

  private String activityId;
  private String activityName;
  private String activityDescription;
  private GwtQName portType;
  private String operationName;


  private ProcessEndpoints parent;

  /**
   * Default constructor for serialization only
   */
  public ActivityEndpoint() {
  }

  public ActivityEndpoint(final String activityId, final String activityName, final String activityDescription,
                          final GwtQName portType, final String operationName) {
    this.activityId = activityId;
    this.activityName = activityName;
    this.activityDescription = activityDescription;
    this.portType = portType;
    this.operationName = operationName;
  }

  public String getActivityId() {
    return activityId;
  }

  public String getActivityName() {
    return activityName;
  }

  public GwtQName getPortType() {
    return portType;
  }

  public String getOperationName() {
    return operationName;
  }

  public ProcessEndpoints getParent() {
    return parent;
  }

  public String getActivityDescription() {
    return activityDescription;
  }

  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }

  public void setActivityName(String activityName) {
    this.activityName = activityName;
  }

  public void setPortType(GwtQName portType) {
    this.portType = portType;
  }

  public void setOperationName(String operationName) {
    this.operationName = operationName;
  }

  public void setParent(ProcessEndpoints parent) {
    this.parent = parent;
  }

  public void setActivityDescription(String activityDescription) {
    this.activityDescription = activityDescription;
  }
}
