/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * @author Loic Albertin
 */
public class ProcessEndpoints implements IsSerializable {

  private String processId;
  private String processName;
  private Collection<ActivityEndpoint> activityEndpoints = new HashSet<ActivityEndpoint>(8);

  /**
   * Default constructor for serialization only
   */
  public ProcessEndpoints() {
  }

  public ProcessEndpoints(final String processId) {
    this(processId, null);
  }

  public ProcessEndpoints(final String processId, final String processName) {
      this(processId, processName, null);
    }

  public ProcessEndpoints(final String processId, final String processName, final ActivityEndpoint activityEndpoint) {
    this.processId = processId;
    this.processName = processName;
    if (activityEndpoint != null) {
      this.activityEndpoints.add(activityEndpoint);
      activityEndpoint.setParent(this);
    }
  }


  public String getProcessId() {
    return processId;
  }

  public Collection<ActivityEndpoint> getActivityEndpoints() {
    return activityEndpoints;
  }

  public void addActivityEndpoint(final ActivityEndpoint activityEndpoint) {
    activityEndpoint.setParent(this);
    this.activityEndpoints.add(activityEndpoint);
  }

  public String getProcessName() {
    return processName;
  }

  public void setProcessName(String processName) {
    this.processName = processName;
  }

  /**
   * For serialization only
   */
  public void setProcessId(String processId) {
    this.processId = processId;
  }

  /**
     * For serialization only
     */
  public void setActivityEndpoints(Collection<ActivityEndpoint> activityEndpoints) {
    this.activityEndpoints = activityEndpoints;
  }
}
