/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.model;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author Loic Albertin
 */
public class SoapRequest implements IsSerializable {

  private ActivityEndpoint activityEndpoint;
  private String soapAction;
  private String request;
  private String endpointUrl;

  /**
   * Default constructor for serialization only
   */
  public SoapRequest() {
  }

  public SoapRequest(ActivityEndpoint activityEndpoint, String soapAction, String endpointUrl, String request) {
    this.activityEndpoint = activityEndpoint;
    this.soapAction = soapAction;
    this.endpointUrl = endpointUrl;
    this.request = request;
  }

  public ActivityEndpoint getActivityEndpoint() {
    return activityEndpoint;
  }

  public String getSoapAction() {
    return soapAction;
  }

  public String getEndpointUrl() {
    return endpointUrl;
  }

  public String getRequest() {
    return request;
  }

  public void setRequest(String request) {
    this.request = request;
  }

  /*
   * Setters for serialization only
   */

  public void setActivityEndpoint(ActivityEndpoint activityEndpoint) {
    this.activityEndpoint = activityEndpoint;
  }

  public void setSoapAction(String soapAction) {
    this.soapAction = soapAction;
  }

  public void setEndpointUrl(String endpointUrl) {
    this.endpointUrl = endpointUrl;
  }
}
