/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.presenters.ws.explorer;

import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.client.ui.popup.Popup;
import org.ow2.orchestra.console.ws.client.WSConsoleServices;
import org.ow2.orchestra.console.ws.client.events.ExploreProcessEndpointsEvent;
import org.ow2.orchestra.console.ws.client.events.OpenActivityEndpointEvent;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.ProcessEndpoints;
import org.ow2.orchestra.console.ws.client.ui.ws.explorer.ProcessEndpointsExplorer;

/**
 * @author Loic Albertin
 */
public class ProcessEndpointsExplorerPresenterImpl implements ProcessEndpointsExplorer.ProcessEndpointsExplorerPresenter {

  private ProcessEndpointsExplorer view;

  private EventBus eventBus;

  public ProcessEndpointsExplorerPresenterImpl(ProcessEndpointsExplorer view, EventBus bus) {
    this.view = view;
    this.eventBus = bus;

    bus.addHandler(ExploreProcessEndpointsEvent.TYPE, new ExploreProcessEndpointsEvent.ExploreProcessEndpointsEventHandler() {
      public void onExploreProcessEndpoints(ExploreProcessEndpointsEvent event) {
        ProcessEndpointsExplorerPresenterImpl.this.exploreProcess(event.getWsdlUrl());
      }
    });
  }

  public void onOpen(final OpenEvent<TreeItem> treeItemOpenEvent) {
    final TreeItem targetItem = treeItemOpenEvent.getTarget();
    targetItem.setState(true, false);
  }

  public void clear() {
    this.view.clear();
  }

  public void exploreProcess(final String processId) {
    WSConsoleServices.App.getInstance().getProcessEndpoints(processId, new AsyncCallback<ProcessEndpoints>() {
      public void onFailure(Throwable caught) {
        if (caught instanceof OrchestraGwtException){
          Popup.show((OrchestraGwtException) caught);
        } else  {
          Popup.showError(caught.getMessage());
        }
      }

      public void onSuccess(ProcessEndpoints result) {
        final List<ProcessEndpoints> list = new ArrayList<ProcessEndpoints>();
        list.add(result);
        ProcessEndpointsExplorerPresenterImpl.this.exploreProcessEndpoints(list, true);
      }
    });
  }

  public void exploreProcessEndpoints(final List<ProcessEndpoints> processEndpointsList,
                                      final boolean displayRootElement) {
    for (ProcessEndpoints processEndpoints : processEndpointsList) {
      if (displayRootElement) {
        TreeItem parentTreeItem = this.view.addItem("Process: " + processEndpoints.getProcessName() + " (Id: " +
            processEndpoints.getProcessId() + ")");
        parentTreeItem.setUserObject(processEndpoints);
        for (ActivityEndpoint activityEndpoint : processEndpoints.getActivityEndpoints()) {
          TreeItem activityTreeItem = parentTreeItem.addItem(activityEndpoint.getActivityName());
          activityTreeItem.setUserObject(activityEndpoint);
          activityTreeItem.setTitle(activityEndpoint.getActivityDescription());
        }
      } else {
        for (ActivityEndpoint activityEndpoint : processEndpoints.getActivityEndpoints()) {
          TreeItem activityTreeItem = this.view.addItem(activityEndpoint.getActivityName());
          activityTreeItem.setUserObject(activityEndpoint);
          activityTreeItem.setTitle(activityEndpoint.getActivityDescription());
        }
      }
    }

  }

  public void onSelection(SelectionEvent<TreeItem> treeItemSelectionEvent) {
    final TreeItem targetItem = treeItemSelectionEvent.getSelectedItem();
    if (targetItem.getUserObject() instanceof ActivityEndpoint) {
      ActivityEndpoint activityEndpoint = (ActivityEndpoint) targetItem.getUserObject();
      eventBus.fireEvent(new OpenActivityEndpointEvent(activityEndpoint));
    } else if (targetItem.getUserObject() instanceof ProcessEndpoints) {
      OpenEvent.fire((HasOpenHandlers<TreeItem>) treeItemSelectionEvent.getSource(), targetItem);
    }
  }
}
