/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.presenters.ws.interactions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.client.ui.popup.Popup;
import org.ow2.orchestra.console.ws.client.WSConsoleServices;
import org.ow2.orchestra.console.ws.client.events.OpenActivityEndpointEvent;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;
import org.ow2.orchestra.console.ws.client.ui.ws.interactions.RequestResponsePanel;

/**
 * @author Loic Albertin
 */
public class RequestResponsePresenter implements RequestResponsePanel.Presenter {

  private RequestResponsePanel requestResponsePanel;

  public RequestResponsePresenter(EventBus eventBus, RequestResponsePanel requestResponsePanel) {
    this.requestResponsePanel = requestResponsePanel;
    eventBus.addHandler(OpenActivityEndpointEvent.TYPE, new OpenActivityEndpointEvent.OpenActivityEndpointEventHandler() {
      public void onOpenOperation(OpenActivityEndpointEvent event) {
        RequestResponsePresenter.this.handleOpenOperation(event.getActivityEndpoint());
      }
    });
  }

  public void handleOpenOperation(final ActivityEndpoint wsdlOperation) {
    requestResponsePanel.addRequestResponseTab(wsdlOperation);
  }

  public void generateRequest(final String key, final ActivityEndpoint wsdlOperation) {
    WSConsoleServices.App.getInstance().generateRequest(wsdlOperation, new AsyncCallback<SoapRequest>() {
      public void onFailure(Throwable caught) {
        if (caught instanceof OrchestraGwtException) {
          Popup.show((OrchestraGwtException) caught);
        } else {
          Popup.showError(caught.getMessage());
        }
        GWT.log("Unable to access ws console!\n" + caught.getMessage());
      }

      public void onSuccess(SoapRequest request) {
        requestResponsePanel.displayRequest(key, request);
      }
    });
  }

  public void sendRequest(final String key, final SoapRequest request) {
    WSConsoleServices.App.getInstance().sendRequest(request, new AsyncCallback<String>() {
      public void onFailure(Throwable caught) {
        if (caught instanceof OrchestraGwtException) {
          Popup.show((OrchestraGwtException) caught);
        } else {
          Popup.showError(caught.getMessage());
        }
        GWT.log("Unable to access ws console!\n" + caught.getMessage());
      }

      public void onSuccess(String result) {
        RequestResponsePresenter.this.requestResponsePanel.displayResult(key, request, result);
      }
    });
  }
}
