/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.console.ws.client.ui.ws.interactions;

import com.google.gwt.user.client.ui.IsWidget;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;

/**
 * @author Loic Albertin
 */
public interface RequestResponsePanel extends IsWidget {

  public interface Presenter {

    void handleOpenOperation(final ActivityEndpoint wsdlOperation);

    void generateRequest(final String key, final ActivityEndpoint wsdlOperation);

    void sendRequest(final String key, final SoapRequest request);
  }

  void setPresenter(Presenter presenter);

  void addRequestResponseTab(final ActivityEndpoint wsdlOperation);

  void displayRequest(final String key, final SoapRequest request);

  void displayResult(final String key, final SoapRequest request, final String result);
}
