/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.client.presenters.ws.explorer;

import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.client.ui.popup.Popup;
import org.ow2.orchestra.console.ws.client.WSConsoleServices;
import org.ow2.orchestra.console.ws.client.events.ExploreProcessEndpointsEvent;
import org.ow2.orchestra.console.ws.client.events.OpenActivityEndpointEvent;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.ProcessEndpoints;
import org.ow2.orchestra.console.ws.client.ui.ws.explorer.ProcessEndpointsExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEndpointsExplorerPresenterImpl
implements ProcessEndpointsExplorer.ProcessEndpointsExplorerPresenter {
    private ProcessEndpointsExplorer view;
    private EventBus eventBus;

    public ProcessEndpointsExplorerPresenterImpl(ProcessEndpointsExplorer view, EventBus bus) {
        this.view = view;
        this.eventBus = bus;
        bus.addHandler(ExploreProcessEndpointsEvent.TYPE, (EventHandler)new ExploreProcessEndpointsEvent.ExploreProcessEndpointsEventHandler(){

            public void onExploreProcessEndpoints(ExploreProcessEndpointsEvent event) {
                ProcessEndpointsExplorerPresenterImpl.this.exploreProcess(event.getWsdlUrl());
            }
        });
    }

    public void onOpen(OpenEvent<TreeItem> treeItemOpenEvent) {
        TreeItem targetItem = (TreeItem)treeItemOpenEvent.getTarget();
        targetItem.setState(true, false);
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void exploreProcess(String processId) {
        WSConsoleServices.App.getInstance().getProcessEndpoints(processId, new AsyncCallback<ProcessEndpoints>(){

            public void onFailure(Throwable caught) {
                if (caught instanceof OrchestraGwtException) {
                    Popup.show((OrchestraGwtException)((OrchestraGwtException)caught));
                } else {
                    Popup.showError((String)caught.getMessage());
                }
            }

            public void onSuccess(ProcessEndpoints result) {
                ArrayList<ProcessEndpoints> list = new ArrayList<ProcessEndpoints>();
                list.add(result);
                ProcessEndpointsExplorerPresenterImpl.this.exploreProcessEndpoints(list, true);
            }
        });
    }

    @Override
    public void exploreProcessEndpoints(List<ProcessEndpoints> processEndpointsList, boolean displayRootElement) {
        for (ProcessEndpoints processEndpoints : processEndpointsList) {
            if (displayRootElement) {
                TreeItem parentTreeItem = this.view.addItem("Process: " + processEndpoints.getProcessName() + " (Id: " + processEndpoints.getProcessId() + ")");
                parentTreeItem.setUserObject((Object)processEndpoints);
                for (ActivityEndpoint activityEndpoint : processEndpoints.getActivityEndpoints()) {
                    TreeItem activityTreeItem = parentTreeItem.addItem(activityEndpoint.getActivityName());
                    activityTreeItem.setUserObject((Object)activityEndpoint);
                    activityTreeItem.setTitle(activityEndpoint.getActivityDescription());
                }
                continue;
            }
            for (ActivityEndpoint activityEndpoint : processEndpoints.getActivityEndpoints()) {
                TreeItem activityTreeItem = this.view.addItem(activityEndpoint.getActivityName());
                activityTreeItem.setUserObject((Object)activityEndpoint);
                activityTreeItem.setTitle(activityEndpoint.getActivityDescription());
            }
        }
    }

    public void onSelection(SelectionEvent<TreeItem> treeItemSelectionEvent) {
        TreeItem targetItem = (TreeItem)treeItemSelectionEvent.getSelectedItem();
        if (targetItem.getUserObject() instanceof ActivityEndpoint) {
            ActivityEndpoint activityEndpoint = (ActivityEndpoint)targetItem.getUserObject();
            this.eventBus.fireEvent((GwtEvent)new OpenActivityEndpointEvent(activityEndpoint));
        } else if (targetItem.getUserObject() instanceof ProcessEndpoints) {
            OpenEvent.fire((HasOpenHandlers)((HasOpenHandlers)treeItemSelectionEvent.getSource()), (Object)targetItem);
        }
    }
}

