/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.client.presenters.ws.interactions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.client.ui.popup.Popup;
import org.ow2.orchestra.console.ws.client.WSConsoleServices;
import org.ow2.orchestra.console.ws.client.events.OpenActivityEndpointEvent;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;
import org.ow2.orchestra.console.ws.client.ui.ws.interactions.RequestResponsePanel;

public class RequestResponsePresenter
implements RequestResponsePanel.Presenter {
    private RequestResponsePanel requestResponsePanel;

    public RequestResponsePresenter(EventBus eventBus, RequestResponsePanel requestResponsePanel) {
        this.requestResponsePanel = requestResponsePanel;
        eventBus.addHandler(OpenActivityEndpointEvent.TYPE, (EventHandler)new OpenActivityEndpointEvent.OpenActivityEndpointEventHandler(){

            public void onOpenOperation(OpenActivityEndpointEvent event) {
                RequestResponsePresenter.this.handleOpenOperation(event.getActivityEndpoint());
            }
        });
    }

    public void handleOpenOperation(ActivityEndpoint wsdlOperation) {
        this.requestResponsePanel.addRequestResponseTab(wsdlOperation);
    }

    public void generateRequest(final String key, ActivityEndpoint wsdlOperation) {
        WSConsoleServices.App.getInstance().generateRequest(wsdlOperation, new AsyncCallback<SoapRequest>(){

            public void onFailure(Throwable caught) {
                if (caught instanceof OrchestraGwtException) {
                    Popup.show((OrchestraGwtException)((OrchestraGwtException)caught));
                } else {
                    Popup.showError((String)caught.getMessage());
                }
                GWT.log((String)("Unable to access ws console!\n" + caught.getMessage()));
            }

            public void onSuccess(SoapRequest request) {
                RequestResponsePresenter.this.requestResponsePanel.displayRequest(key, request);
            }
        });
    }

    public void sendRequest(final String key, final SoapRequest request) {
        WSConsoleServices.App.getInstance().sendRequest(request, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                if (caught instanceof OrchestraGwtException) {
                    Popup.show((OrchestraGwtException)((OrchestraGwtException)caught));
                } else {
                    Popup.showError((String)caught.getMessage());
                }
                GWT.log((String)("Unable to access ws console!\n" + caught.getMessage()));
            }

            public void onSuccess(String result) {
                RequestResponsePresenter.this.requestResponsePanel.displayResult(key, request, result);
            }
        });
    }
}

