/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.client.ui.ws.interactions.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.common.gwt.utils.client.events.CloseTabEvent;
import org.ow2.orchestra.common.gwt.utils.client.ui.ClosableTabHeader;
import org.ow2.orchestra.common.gwt.utils.client.ui.ScrollableTabLayoutPanelContainer;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;
import org.ow2.orchestra.console.ws.client.ui.ws.interactions.RequestResponsePanel;
import org.ow2.orchestra.console.ws.client.ui.ws.interactions.impl.RequestResponseArea;

public class DefaultRequestResponsePanel
extends Composite
implements RequestResponsePanel {
    private static RequestResponsePanelUiBinder ourUiBinder = (RequestResponsePanelUiBinder)GWT.create(RequestResponsePanelUiBinder.class);
    private RequestResponsePanel.Presenter presenter;
    private EventBus eventBus = new SimpleEventBus();
    private long nextKey = 0L;
    @UiField
    ScrollableTabLayoutPanelContainer tabPanel;
    private Map<String, Tab> keysToTab = new HashMap<String, Tab>();

    public DefaultRequestResponsePanel() {
        this.initWidget((Widget)ourUiBinder.createAndBindUi(this));
        this.eventBus.addHandler(CloseTabEvent.TYPE, (EventHandler)new CloseTabEvent.CloseTabEventHandler(){

            public void onCloseTab(CloseTabEvent event) {
                DefaultRequestResponsePanel.this.tabPanel.getScrollableTabLayoutPanel().remove((Widget)((Tab)DefaultRequestResponsePanel.this.keysToTab.get(event.getKey())).getArea());
                DefaultRequestResponsePanel.this.keysToTab.remove(event.getKey());
            }
        });
    }

    public void setPresenter(RequestResponsePanel.Presenter presenter) {
        this.presenter = presenter;
    }

    public void addRequestResponseTab(ActivityEndpoint activityEndpoint) {
        String defaultName = activityEndpoint.getPortType().getLocalPart() + "." + activityEndpoint.getOperationName();
        String key = null;
        for (Map.Entry<String, Tab> stringTabEntry : this.keysToTab.entrySet()) {
            if (!defaultName.equals(stringTabEntry.getValue().getHeader().getLabel().getText())) continue;
            key = stringTabEntry.getKey();
            break;
        }
        if (key == null) {
            key = this.generateKey();
            this.presenter.generateRequest(key, activityEndpoint);
        } else {
            this.tabPanel.getScrollableTabLayoutPanel().selectTab((Widget)this.keysToTab.get(key).getArea());
        }
    }

    public void displayRequest(String key, SoapRequest request) {
        RequestResponseArea widget = new RequestResponseArea(key, request, this.presenter);
        ClosableTabHeader header = new ClosableTabHeader(request.getActivityEndpoint().getPortType().getLocalPart() + "." + request.getActivityEndpoint().getOperationName(), this.eventBus, key, true, true);
        this.keysToTab.put(key, new Tab(header, widget));
        this.tabPanel.getScrollableTabLayoutPanel().add((Widget)widget, (Widget)header);
        this.tabPanel.getScrollableTabLayoutPanel().selectTab((Widget)widget);
    }

    public void displayResult(String key, SoapRequest request, String result) {
        Widget widget = this.tabPanel.getScrollableTabLayoutPanel().getWidget(this.tabPanel.getScrollableTabLayoutPanel().getWidgetIndex((Widget)this.keysToTab.get(key).getArea()));
        if (widget instanceof RequestResponseArea) {
            ((RequestResponseArea)widget).displayResult(result);
        }
    }

    private String generateKey() {
        return "key" + ++this.nextKey;
    }

    private class Tab {
        private ClosableTabHeader header;
        private RequestResponseArea area;

        private Tab(ClosableTabHeader header, RequestResponseArea area) {
            this.header = header;
            this.area = area;
        }

        public ClosableTabHeader getHeader() {
            return this.header;
        }

        public RequestResponseArea getArea() {
            return this.area;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RequestResponsePanelUiBinder
    extends UiBinder<Widget, DefaultRequestResponsePanel> {
    }
}

