/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.client.ui.ws.interactions.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;
import org.ow2.orchestra.console.ws.client.ui.ws.interactions.RequestResponsePanel;

public class RequestResponseArea
extends Composite {
    private static RequestResponseAreaUiBinder ourUiBinder = (RequestResponseAreaUiBinder)GWT.create(RequestResponseAreaUiBinder.class);
    @UiField
    Button sendButton;
    @UiField
    TextArea requestArea;
    @UiField
    TextArea responseArea;
    @UiField
    SplitLayoutPanel splitPanel;
    @UiField
    Label details;
    private final RequestResponsePanel.Presenter presenter;
    private String key;
    private final SoapRequest soapRequest;
    public static final double REDUCED_TEXT_AREA_SIZE = 70.0;

    public RequestResponseArea(String key, SoapRequest soapRequest, RequestResponsePanel.Presenter presenter) {
        this.initWidget((Widget)ourUiBinder.createAndBindUi((Object)this));
        this.requestArea.setText(soapRequest.getRequest());
        this.presenter = presenter;
        this.soapRequest = soapRequest;
        this.key = key;
        this.details.setText("Interface: " + soapRequest.getActivityEndpoint().getPortType().getLocalPart() + ", " + "Operation: " + soapRequest.getActivityEndpoint().getOperationName());
    }

    public void displayResult(String result) {
        this.responseArea.setText(result);
        this.splitPanel.setWidgetSize((Widget)this.requestArea, 70.0);
        this.splitPanel.forceLayout();
    }

    @UiHandler(value={"sendButton"})
    public void handleClick(ClickEvent event) {
        if (this.requestArea.getText() != null && this.requestArea.getText() != null) {
            this.soapRequest.setRequest(this.requestArea.getText());
            this.presenter.sendRequest(this.key, this.soapRequest);
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RequestResponseAreaUiBinder
    extends UiBinder<Widget, RequestResponseArea> {
    }
}

