/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.common.gwt.utils.client.model.GwtQName;
import org.ow2.orchestra.common.gwt.utils.server.OrchestraGwtServlet;
import org.ow2.orchestra.console.ws.client.WSConsoleServices;
import org.ow2.orchestra.console.ws.client.model.ActivityEndpoint;
import org.ow2.orchestra.console.ws.client.model.ProcessEndpoints;
import org.ow2.orchestra.console.ws.client.model.SoapRequest;
import org.ow2.orchestra.console.ws.server.XBeansUtils;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.OnEventDefinition;
import org.ow2.orchestra.facade.def.OnMessageDefinition;
import org.ow2.orchestra.facade.def.PickActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ReceiveActivityDefinition;
import org.ow2.orchestra.facade.def.ScopeActivityDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.util.OrchestraUrlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WSDLInMemoryLocator;
import org.ow2.orchestra.util.wsdl.WsdlInlineUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSConsoleServlet
extends OrchestraGwtServlet
implements WSConsoleServices {
    private static final long serialVersionUID = -1387870563519784245L;

    @Override
    public ProcessEndpoints getProcessEndpoints(String processId) throws OrchestraGwtException {
        Set activityDefinitions;
        ProcessDefinition processDefinition;
        QueryDefinitionAPI queryDefinitionAPI = (QueryDefinitionAPI)this.getAPI(QueryDefinitionAPI.class);
        ProcessDefinitionUUID processDefinitionUUID = new ProcessDefinitionUUID(processId);
        try {
            processDefinition = queryDefinitionAPI.getProcessDefinition(processDefinitionUUID);
            activityDefinitions = queryDefinitionAPI.findActivityDefinitions(processDefinitionUUID);
        }
        catch (ProcessNotFoundException e) {
            throw new OrchestraGwtException("Process '" + processId + "' not found.", e.getMessage());
        }
        ProcessEndpoints processEndpoints = new ProcessEndpoints(processId, processDefinition.getName());
        for (ActivityDefinition activityDefinition : activityDefinitions) {
            ActivityEndpoint activityEndpoint;
            String activityDescription = activityDefinition.getDocumentation();
            if (activityDefinition instanceof ReceiveActivityDefinition) {
                ReceiveActivityDefinition receiveActivityDefinition = (ReceiveActivityDefinition)activityDefinition;
                ActivityEndpoint activityEndpoint2 = new ActivityEndpoint(receiveActivityDefinition.getUUID().toString(), receiveActivityDefinition.getName(), activityDescription, GwtQName.valueOf((String)receiveActivityDefinition.getPortType().toString()), receiveActivityDefinition.getOperation());
                processEndpoints.addActivityEndpoint(activityEndpoint2);
                continue;
            }
            if (activityDefinition instanceof PickActivityDefinition) {
                PickActivityDefinition pickActivityDefinition = (PickActivityDefinition)activityDefinition;
                for (OnMessageDefinition onMessageDefinition : pickActivityDefinition.getOnMessageDefinitionList()) {
                    activityEndpoint = new ActivityEndpoint(onMessageDefinition.getActivityDefinitionUUID().toString(), "OnMessage(" + onMessageDefinition.getOperation() + ")", activityDescription, GwtQName.valueOf((String)onMessageDefinition.getPortType().toString()), onMessageDefinition.getOperation());
                    processEndpoints.addActivityEndpoint(activityEndpoint);
                }
                continue;
            }
            if (!(activityDefinition instanceof ScopeActivityDefinition)) continue;
            ScopeActivityDefinition scopeActivityDefinition = (ScopeActivityDefinition)activityDefinition;
            for (OnEventDefinition onEventDefinition : scopeActivityDefinition.getOnEventEventHandlers()) {
                activityEndpoint = new ActivityEndpoint(onEventDefinition.getActivityDefinitionUUID().toString(), "OnEvent(" + onEventDefinition.getOperation() + ")", activityDescription, GwtQName.valueOf((String)onEventDefinition.getPortType().toString()), onEventDefinition.getOperation());
                processEndpoints.addActivityEndpoint(activityEndpoint);
            }
        }
        return processEndpoints;
    }

    @Override
    public SoapRequest generateRequest(ActivityEndpoint activityEndpoint) throws OrchestraGwtException {
        ProcessDefinition processDefinition;
        String processId = activityEndpoint.getParent().getProcessId();
        QueryDefinitionAPI queryDefinitionAPI = (QueryDefinitionAPI)this.getAPI(QueryDefinitionAPI.class);
        ProcessDefinitionUUID processDefinitionUUID = new ProcessDefinitionUUID(processId);
        try {
            processDefinition = queryDefinitionAPI.getProcessDefinition(processDefinitionUUID);
        }
        catch (ProcessNotFoundException e) {
            throw new OrchestraGwtException("Process '" + processId + "' not found.", e.getMessage());
        }
        Collection resourcesName = processDefinition.getProcessResourceNames();
        byte[] bpelContent = null;
        String bpelPath = "";
        HashMap<String, byte[]> wsdlFiles = new HashMap<String, byte[]>();
        for (String resource : resourcesName) {
            if (resource.endsWith(".bpel")) {
                if (bpelContent != null) {
                    throw new OrchestraGwtException("Repository for process '" + processId + "' contains multiples BPEL files. This is not allowed.");
                }
                try {
                    if (resource.contains("/")) {
                        bpelPath = resource.substring(0, resource.lastIndexOf("/") + 1);
                    }
                    bpelContent = queryDefinitionAPI.getProcessResource(processDefinitionUUID, resource);
                    continue;
                }
                catch (ProcessNotFoundException e) {
                    throw new OrchestraGwtException("Process '" + processId + "' not found.", e.getMessage());
                }
            }
            if (!resource.endsWith(".wsdl") && !resource.endsWith(".xsd")) continue;
            try {
                wsdlFiles.put(resource, queryDefinitionAPI.getProcessResource(processDefinitionUUID, resource));
            }
            catch (ProcessNotFoundException e) {
                throw new OrchestraGwtException("Process '" + processId + "' not found.", e.getMessage());
            }
        }
        if (bpelContent == null) {
            throw new OrchestraGwtException("BPEL definition not found for process '" + processId + "'");
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        HashSet<Definition> definitions = new HashSet<Definition>();
        Document bpelDocument = XmlUtil.getDocumentFromInputStream((InputStream)new ByteArrayInputStream(bpelContent));
        NodeList imports = bpelDocument.getElementsByTagNameNS("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "import");
        for (int i = 0; i < imports.getLength(); ++i) {
            Element importElement = (Element)imports.item(i);
            String location = null;
            if (importElement.hasAttribute("location")) {
                location = importElement.getAttribute("location");
            }
            String importType = null;
            if (importElement.hasAttribute("importType")) {
                importType = importElement.getAttribute("importType");
            }
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(importType)) continue;
            Definition definition = WsdlUtil.readWsdl((WSDLLocator)new WSDLInMemoryLocator(location, bpelPath, wsdlFiles));
            WsdlInlineUtil.inlineWsdlFile((Definition)definition);
            definitions.add(definition);
            Map definitionNamespaces = definition.getNamespaces();
            Types types = definition.getTypes();
            if (types == null) continue;
            for (ExtensibilityElement elt : new ArrayList(types.getExtensibilityElements())) {
                if (!(elt instanceof Schema)) continue;
                for (Map.Entry entry : definitionNamespaces.entrySet()) {
                    if (((Schema)elt).getElement().hasAttribute("".equals(entry.getKey()) ? "xmlns" : "xmlns:" + (String)entry.getKey())) continue;
                    ((Schema)elt).getElement().setAttribute("".equals(entry.getKey()) ? "xmlns" : "xmlns:" + (String)entry.getKey(), (String)entry.getValue());
                }
                schemas.add((Schema)elt);
            }
        }
        return this.generateSoapRequest(activityEndpoint, schemas, definitions);
    }

    private SoapRequest generateSoapRequest(ActivityEndpoint activityEndpoint, List<Schema> schemas, Set<Definition> definitions) throws OrchestraGwtException {
        String processId = activityEndpoint.getParent().getProcessId();
        for (Definition definition : definitions) {
            BindingOperation bindingOperation;
            Operation operation;
            PortType portType = definition.getPortType(QName.valueOf(activityEndpoint.getPortType().toString()));
            if (portType == null || (operation = portType.getOperation(activityEndpoint.getOperationName(), null, null)) == null || (bindingOperation = WsdlUtil.getBindingOperation((Definition)definition, (String)operation.getName())) == null) continue;
            String soapAction = WsdlUtil.getSoapAction((BindingOperation)WsdlUtil.getBindingOperation((Definition)definition, (String)operation.getName()));
            XmlCursor xmlCursor = null;
            try {
                boolean isRpc = WsdlUtil.isRpc((Definition)definition, (BindingOperation)bindingOperation);
                HashMap<String, String> suggestedPrefix = new HashMap<String, String>();
                suggestedPrefix.put("http://schemas.xmlsoap.org/soap/envelope/", "env");
                XmlOptions options = new XmlOptions().setSaveSuggestedPrefixes(suggestedPrefix);
                XmlObject soapMessage = XmlObject.Factory.newInstance((XmlOptions)options);
                xmlCursor = soapMessage.newCursor();
                xmlCursor.toNextToken();
                xmlCursor.beginElement("Envelope", "http://schemas.xmlsoap.org/soap/envelope/");
                xmlCursor.toFirstChild();
                xmlCursor.beginElement("Header", "http://schemas.xmlsoap.org/soap/envelope/");
                xmlCursor.toFirstChild();
                List extensibilityElements = bindingOperation.getExtensibilityElements();
                List soapHeaders = WsdlUtil.getExtensibilityElements((List)extensibilityElements, SOAPHeader.class);
                for (SOAPHeader soapHeader : soapHeaders) {
                    Message headerMessage = definition.getMessage(soapHeader.getMessage());
                    if (headerMessage == null) continue;
                    List parts = headerMessage.getOrderedParts(null);
                    for (Part part : parts) {
                        XBeansUtils.createPartElement(part, schemas, xmlCursor, options);
                    }
                }
                xmlCursor.toParent();
                xmlCursor.toLastChild();
                xmlCursor.toEndToken();
                xmlCursor.toNextToken();
                xmlCursor.beginElement("Body", "http://schemas.xmlsoap.org/soap/envelope/");
                xmlCursor.toFirstChild();
                Input input = operation.getInput();
                Message message = input.getMessage();
                if (isRpc) {
                    xmlCursor.beginElement(message.getQName());
                    xmlCursor.toFirstChild();
                }
                List parts = message.getOrderedParts(null);
                for (Part part : parts) {
                    xmlCursor.push();
                    xmlCursor.toLastChild();
                    XBeansUtils.createPartElement(part, schemas, xmlCursor, options);
                    xmlCursor.pop();
                }
                SoapRequest soapRequest = new SoapRequest(activityEndpoint, soapAction, this.retrieveEndpointUrl(definitions, portType), XBeansUtils.prettyToString(soapMessage));
                return soapRequest;
            }
            catch (Exception e) {
                throw new OrchestraGwtException("Process '" + processId + "' unable to build SOAP request.", e.getMessage());
            }
            finally {
                if (xmlCursor != null) {
                    xmlCursor.dispose();
                }
            }
        }
        throw new OrchestraGwtException("Process '" + processId + "' unable to build SOAP request.");
    }

    private String retrieveEndpointUrl(Set<Definition> definitions, PortType portType) throws OrchestraGwtException {
        String endpointUrlString = "";
        List services = WsdlUtil.getServicesOfPortType((QName)portType.getQName(), definitions);
        for (Service service : services) {
            Map portsMap = service.getPorts();
            for (Map.Entry entry : portsMap.entrySet()) {
                URI endpointUrl;
                if (!((Port)entry.getValue()).getBinding().getPortType().equals(portType)) continue;
                SOAPAddress soapAddress = (SOAPAddress)WsdlUtil.getExtensibilityElement((List)((Port)entry.getValue()).getExtensibilityElements(), SOAPAddress.class);
                try {
                    endpointUrl = new URI(OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)soapAddress.getLocationURI(), (Properties)this.getSessionAPIs().getOrchestraProperties()));
                }
                catch (URISyntaxException e) {
                    continue;
                }
                endpointUrlString = endpointUrl.toString();
            }
        }
        if ("".equals(endpointUrlString)) {
            throw new OrchestraGwtException("Unable to get WS endpoint url from WSDLs.");
        }
        return endpointUrlString;
    }

    @Override
    public String sendRequest(SoapRequest soapRequest) throws OrchestraGwtException {
        ActivityEndpoint activityEndpoint = soapRequest.getActivityEndpoint();
        String processId = activityEndpoint.getParent().getProcessId();
        SOAPMessage soapMessage = SOAPUtil.buildSOAPMessage((String)soapRequest.getSoapAction(), (String)soapRequest.getRequest());
        SOAPMessage soapResponse = SOAPUtil.call((SOAPMessage)soapMessage, (String)soapRequest.getEndpointUrl());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            soapResponse.writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new OrchestraGwtException("Process '" + processId + "' retrieve SOAP request.", e.getMessage());
        }
        try {
            return XBeansUtils.prettyToString(outputStream.toString());
        }
        catch (Exception e) {
            throw new OrchestraGwtException("Process '" + processId + "': unable to retrieve SOAP response.", e.getMessage());
        }
    }
}

