/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.ws.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.wsdl.Part;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.ow2.orchestra.common.gwt.utils.client.OrchestraGwtException;
import org.ow2.orchestra.console.ws.server.xsd2inst.SampleXmlUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBeansUtils {
    private XBeansUtils() {
    }

    public static String prettyToString(String xmlAsString) throws XmlException, IOException {
        StringWriter stringWriter = new StringWriter();
        XmlObject xmlObject = XmlObject.Factory.parse((String)xmlAsString);
        XBeansUtils.prettyWrite(xmlObject, stringWriter);
        return stringWriter.toString();
    }

    public static String prettyToString(XmlObject xmlObject) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XBeansUtils.prettyWrite(xmlObject, stringWriter);
        return stringWriter.toString();
    }

    public static void prettyWrite(XmlObject xmlObject, Writer writer) throws IOException {
        XBeansUtils.prettyWrite(xmlObject, writer, null);
    }

    public static void prettyWrite(XmlObject xmlObject, Writer writer, XmlOptions options) throws IOException {
        if (options == null) {
            options = new XmlOptions();
        }
        options.setSavePrettyPrint().setSavePrettyPrintIndent(2).setSaveNoXmlDecl().setSaveAggressiveNamespaces();
        xmlObject.save(writer, options);
    }

    private static SchemaTypeLoader getSchemaTypeLoaderFromSchemas(List<Schema> schemas, XmlOptions options) throws OrchestraGwtException {
        XmlObject[] wsdlObj = new XmlObject[schemas.size()];
        for (int i = 0; i < schemas.size(); ++i) {
            try {
                wsdlObj[i] = XmlObject.Factory.parse((Node)schemas.get(i).getElement());
                continue;
            }
            catch (XmlException e) {
                throw new OrchestraGwtException("Unable to build SOAP request.", e.getMessage());
            }
        }
        try {
            SchemaTypeSystem schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])wsdlObj, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)options);
            return XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{schemaTypeSystem, XmlBeans.getBuiltinTypeSystem()});
        }
        catch (XmlException e) {
            throw new OrchestraGwtException("Unable to build SOAP request.", e.getMessage());
        }
    }

    public static void createPartElement(Part part, List<Schema> schemas, XmlCursor partCursor, XmlOptions options) throws OrchestraGwtException {
        SchemaType type;
        SchemaTypeLoader schemaTypeLoader = XBeansUtils.getSchemaTypeLoaderFromSchemas(schemas, options);
        QName elementName = part.getElementName();
        QName typeName = part.getTypeName();
        if (typeName != null) {
            partCursor.beginElement(part.getName());
            type = schemaTypeLoader.findType(typeName);
        } else {
            partCursor.beginElement(elementName);
            SchemaGlobalElement elm = schemaTypeLoader.findElement(elementName);
            type = elm.getType();
        }
        partCursor.toFirstChild();
        new SampleXmlUtil(false).createSampleForType(type, partCursor);
        partCursor.toParent();
    }
}

