/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 * Management operations.<br>
 *
 * @author Guillaume Porcher
 */
public interface ManagementAPI {

  /**
   * To deploy a process giving the bytes table of an archive file.<br>
   * The archive should contains the .bpel file and the .wsdl files.
   * @param barFile The bytes table of the bar file.
   * @return The recorded data of the deployed process.
   */
  ProcessDefinition deployBar(byte[] barFile);

  /**
   * To deploy the package giving the deployment object.
   * @param deployment The deployment object that should contain the bpel file and the wsdl definitions.
   * @return The recorded data of the deployed process.
   */
  ProcessDefinition deploy(Deployment deployment);

  /**
   * To undeploy the process giving the qualified name of the process.
   * @param processQName The qualified name.
   * @return true if the process has been succesfully undeployed otherwise
   * returns false.
   */
  boolean undeploy(QName processQName);

  /**
   * To undeploy the process giving the uuid of the process.
   * @param processDefinitionUUID te uuid of the process
   * @return true if the process has been succesfully undeployed otherwise
   * returns false.
   */
  boolean undeploy(ProcessDefinitionUUID processDefinitionUUID);

  /**
   * Redeploy all web services.
   * Use after a reboot to restore the previous environment.
   */
  void initialize();
}
