/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade;

import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.util.Misc;

/**
 * This class provide access to Orchestra APIs
 *
 * @author Gael Lalire
 */
public final class AccessorUtil {

  public static final String OBJECT_NAME = "JMXAgent:name=orchestraRemoteDeployer";

  public static final String SERVICE_URL = "service:jmx:rmi:///jndi/rmi://localhost:9999/orchestraServer";

  private AccessorUtil() {
  }

  /**
   *
   * @return a proxy which delegates methods to orchestra
   * @throws OrchestraException if error occurs
   */
  public static QuerierRuntimeAPI getQueryRuntimeAPI(final String serviceURL, final String objectName) throws OrchestraException {
    try {
      return Misc.getMBeanProxy(RemoteDeployerMBean.class, serviceURL, objectName);
    } catch (Exception e) {
      throw new OrchestraException("unable to access API", e);
    }
  }
}
