/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.def;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/**
 * @author S. Ali Tokmen
 */
public class ThrowActivityDefinitionData extends ActivityDefinitionData {

  private static final long serialVersionUID = 7334650841772447225L;

  private QName faultName;

  private String faultVariable;

  public ThrowActivityDefinitionData(final ProcessDefinitionData processDefinitionData, final ActivityDefinitionUUID uuid,
    final ActivityDefinitionUUID encloserUUID, final String name, final QName faultName, final String faultVariable) {
    super(processDefinitionData, uuid, encloserUUID, ActivityType.THROW, name);
    this.faultName = faultName;
    this.faultVariable = faultVariable;
  }

  /**
   * @return The faultName attribute of the throw activity (mandatory).
   */
  public QName getFaultName() {
    return faultName;
  }

  /**
   * @return The faultVariable attribute of the throw activity (optional).
   */
  public String getFaultVariable() {
    return faultVariable;
  }

}
