/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade;

import java.util.Set;

import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.ProcessState;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

/**
 * This interface provide methods which are accessible to client side.
 * Only queries on runtime part are listed.
 * @author Gael Lalire
 */
public interface QuerierRuntimeAPI {

  /**
   * Get informations about activity instances
   *
   * @param processUUID the uuid of the process instance
   * @return a set of activity instances corresponding to processUUID
   */
  Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID processUUID);

  /**
   * Get informations about activity instances
   *
   * @param processUUID the uuid of the process instance
   * @param activityState the state of activities
   * @return a set of activity instances corresponding to processUUID and state
   *         'active'
   */
  Set<ActivityInstance> getActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState);

  /**
   * Get informations about process instances
   *
   * @return a set of all process instances
   */
  Set<ProcessInstance> getProcessInstances();

  /**
   * Get informations about process instances
   *
   * @param processDefinitionUUID the uuid of the process definition
   * @return a set of process instances corresponding to processDefinitionUUID
   */
  Set<ProcessInstance> getProcessInstances(ProcessDefinitionUUID processDefinitionUUID);

  /**
   * Get informations about process instances
   *
   * @param processDefinitionUUID the uuid of the process definition
   * @param processState the state of process instances
   * @return a set of process instances corresponding to processDefinitionUUID
   *         and state 'active'
   */
  Set<ProcessInstance> getProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ProcessState processState);

  /**
   * Get informations about process instances
   *
   * @param processState state of process instances
   * @return a set of process instances corresponding to state 'active'
   */
  Set<ProcessInstance> getProcessInstances(ProcessState processState);

}
