package org.ow2.orchestra.facade.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

import javax.wsdl.Definition;

import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.xml.sax.InputSource;

/**
 * bpel XML process source plus related WSDL XML sources and optional files.
 *
 * bpel deployments can be build from a zip file with
 * {@link #addZipEntries(java.util.zip.ZipInputStream)} or from resources with
 * {@link #addWsdlResource(String)} and {@link #setBpelResource(String)}.
 *
 * @author Tom Baeyens
 */
public class Deployment implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = -5531271839683239304L;

  /** bpel file as an inputSource. */
  private byte[] bpel;

  private URL bpelURL;

  /** wsdl file describing the process as a webservice. */
  private WsdlDefinitions wsdlDefinitions;

  /**
   * add a wsdl in wsdls map.
   *
   * @param inputSource
   *            wsdl to add
   */
  public void addWsdlDefinition(final String namespace, final Definition wsdlDefinition) {
    if (wsdlDefinitions == null) {
      wsdlDefinitions = new WsdlDefinitions();
    }
    wsdlDefinitions.addWsdlDefinition(namespace, wsdlDefinition);
  }

  // /**
  // * set the bpel based on a resource.
  // * @param resource bpel resource
  // * @param classLoader classLoader to use to find the given resource
  // */
  // public void setBpelResource(String resource, ClassLoader classLoader) {
  // InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
  // if (resourceAsStream == null) {
  // throw new OrchestraException("bpel process resource " + resource + " was
  // not
  // found");
  // }
  // bpel = new InputSource(resourceAsStream);
  // }
  /**
   * set the bpel based on an URL.
   *
   * @param url
   *            url to the bpel file
   */
  public void setBpelUrl(final URL url) {
    Misc.checkArgsNotNull(url);
    this.bpelURL = url;
    try {
      InputStream stream = url.openStream();
      ByteArrayOutputStream output = new ByteArrayOutputStream();
      int c;
      while ((c = stream.read()) != -1) {
        output.write(c);
      }
      stream.close();
      bpel = output.toByteArray();
    } catch (Exception e) {
      throw new RuntimeException("couldn't read bpel resource from url "
          + url, e);
    }
  }

  public URL getBpelURL() {
    return bpelURL;
  }

  public InputSource getBpel() {
    return new InputSource(new ByteArrayInputStream(bpel));
  }

  public WsdlDefinitions getWsdlDefinitions() {
    return wsdlDefinitions;
  }
}
