/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.def;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/**
 * FIXME: This class will be abstract
 * @author Gael Lalire
 */
public class ActivityDefinitionData extends AbstractData {

  private static final long serialVersionUID = -740917119643931581L;

  private ProcessDefinitionData processDefinitionData;

  private String name;

  private ActivityType type;

  @SuppressWarnings("unused")
  private ActivityDefinitionUUID uuid;

  @SuppressWarnings("unused")
  private ActivityDefinitionUUID encloserUUID;

  public ActivityDefinitionData(final ProcessDefinitionData processDefinitionData, final ActivityDefinitionUUID uuid,
      final ActivityDefinitionUUID encloserUUID, final ActivityType type, final String name) {
    this.processDefinitionData = processDefinitionData;
    this.uuid = uuid;
    this.encloserUUID = encloserUUID;
    this.type = type;
    this.name = name;
  }

  /**
   * @return the processDefinitionData
   */
  public ProcessDefinitionData getProcessDefinitionData() {
    return processDefinitionData;
  }

  /**
   * @return the name
   */
  public String getName() {
    return name;
  }

  /**
   * @return the type
   */
  public ActivityType getType() {
    return type;
  }

  /**
   * @return the uuid
   */
  /* disabled
  public ActivityDefinitionUUID getUUID() {
    return uuid;
  }
  */

  /* disabled
  public ActivityDefinitionUUID getEncloserUUID() {
    return encloserUUID;
  }
  */

}
