/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.jmx;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.QuerierRuntimeAPI;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;

public interface RemoteDeployerMBean extends QuerierRuntimeAPI {

  /**
   * To deploy a process giving the bytes table of an archive file.<br>
   * The archive should contains the .bpel file and the .wsdl files.
   * @param barFile The bytes table of the bar file.
   * @return The qualified name of the deployed process.
   */
  ProcessDefinitionData deployBar(byte[] barFile);

  /**
   * To deploy the package giving the deployment object.
   * @param deployment The deployment object that should contain the bpel file and the wsdl definitions.
   * @return The qualified name of the deployed process.
   */
  ProcessDefinitionData deploy(Deployment deployment);

  /**
   * To undeploy the process giving the qualified name of the process.
   * @param processQName The qualified name.
   * @return true if the process has been succesfully undeployed otherwise
   * returns false.
   */
  boolean undeploy(QName processQName);

  /**
   * Returns the list of deployed processes.
   * @return The list of process definition data for deployed processes.
   */
  List<ProcessDefinitionData> listProcess();

  void initialize();

}
