package org.ow2.orchestra.facade.wsdl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.wsdl.Definition;

/**
 * maintains the mappings between a namespace and a WSDL definition throughout
 * the whole bpel process deployment. The deployer will make a WsdlDefinitions
 * object available in the object stack of the {@link org.jbpm.pvm.internal.xml.Parse}.
 *
 * This mapping is used to find the wsdl definition when an import element
 * without a location attribute is used in a bpel process.
 *
 * <pre>
 * WsdlDefinitions wsdlDefinitions = parse.findObject(WsdlDefinitions.class);
 * </pre>
 *
 * @author Guillaume Porcher
 */
public class WsdlDefinitions implements Serializable {

  /**
   * Default constructor.
   */
  public WsdlDefinitions() {
  }

  private Map<String, Set<Definition>> definitions = null;

  public void addWsdlDefinition(final String namespace, final Definition wsdlDefinition) {
    if (definitions == null) {
      definitions = new HashMap<String, Set<Definition>>();
    }
    if (!definitions.containsKey(namespace)) {
      definitions.put(namespace, new HashSet<Definition>());
    }
    definitions.get(namespace).add(wsdlDefinition);
  }

  public void removeWsdlDefinition(final String namespace) {
    if (definitions != null) {
      definitions.remove(namespace);
    }
  }

  public Set<Definition> getWsdlDefinitions(final String namespace) {
    if (definitions != null) {
      return definitions.get(namespace);
    }
    return null;
  }
}
