/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime;

/**
 * Bpel activity types supported by Orchestra
 *
 * @author Alfonso Fuca
 */
public enum ActivityType {
   ASSIGN,
   COMPENSATE_SCOPE,
   EMPTY, EXIT, EXTENSION_ACTIVITY,
   FLOW, FOR_EACH,
   IF, INVOKE,
   PICK, PROCESS,
   RECEIVE, REPEAT_UNTIL, REPLY, RETHROW,
   SCOPE, SEQUENCE,
   THROW,
   VALIDATE,
   WAIT, WHILE,
   // Orchestra activities
   EXTENSION_TEST,
   // This temporary type is used when persistence of activity is not written
   UNKNOWN_ACTIVITY;
}
