/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.wsdl.Definition;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.xml.sax.InputSource;

public class Deployment
implements Serializable {
    private static final long serialVersionUID = -5531271839683239304L;
    private byte[] bpel;
    private URL bpelURL;
    private WsdlDefinitions wsdlDefinitions;

    public void addWsdlDefinition(String namespace, Definition wsdlDefinition) {
        if (this.wsdlDefinitions == null) {
            this.wsdlDefinitions = new WsdlDefinitions();
        }
        this.wsdlDefinitions.addWsdlDefinition(namespace, wsdlDefinition);
    }

    public void setBpelUrl(URL url) {
        Misc.checkArgsNotNull((Object[])new Object[]{url});
        this.bpelURL = url;
        try {
            int c;
            InputStream stream = url.openStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                output.write(c);
            }
            stream.close();
            this.bpel = output.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't read bpel resource from url " + url, e);
        }
    }

    public URL getBpelURL() {
        return this.bpelURL;
    }

    public InputSource getBpel() {
        return new InputSource(new ByteArrayInputStream(this.bpel));
    }

    public WsdlDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }
}

